/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LicenseType {
    AWS("AWS"),
    BYOL("BYOL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LicenseType> VALUE_MAP;
    private final String value;

    private LicenseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LicenseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LicenseType> knownValues() {
        EnumSet<LicenseType> knownValues = EnumSet.allOf(LicenseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LicenseType.class, LicenseType::toString);
    }
}

