/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.SmsServiceClientConfiguration;
import software.amazon.awssdk.services.sms.internal.SmsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sms.model.CreateAppRequest;
import software.amazon.awssdk.services.sms.model.CreateAppResponse;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorResponse;
import software.amazon.awssdk.services.sms.model.DryRunOperationException;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse;
import software.amazon.awssdk.services.sms.model.GenerateTemplateRequest;
import software.amazon.awssdk.services.sms.model.GenerateTemplateResponse;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppRequest;
import software.amazon.awssdk.services.sms.model.GetAppResponse;
import software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest;
import software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportAppCatalogResponse;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.InternalErrorException;
import software.amazon.awssdk.services.sms.model.InvalidParameterException;
import software.amazon.awssdk.services.sms.model.LaunchAppRequest;
import software.amazon.awssdk.services.sms.model.LaunchAppResponse;
import software.amazon.awssdk.services.sms.model.ListAppsRequest;
import software.amazon.awssdk.services.sms.model.ListAppsResponse;
import software.amazon.awssdk.services.sms.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sms.model.NoConnectorsAvailableException;
import software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest;
import software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputResponse;
import software.amazon.awssdk.services.sms.model.OperationNotPermittedException;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.ReplicationJobAlreadyExistsException;
import software.amazon.awssdk.services.sms.model.ReplicationJobNotFoundException;
import software.amazon.awssdk.services.sms.model.ReplicationRunLimitExceededException;
import software.amazon.awssdk.services.sms.model.ServerCannotBeReplicatedException;
import software.amazon.awssdk.services.sms.model.SmsException;
import software.amazon.awssdk.services.sms.model.StartAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse;
import software.amazon.awssdk.services.sms.model.StopAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StopAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.TemporarilyUnavailableException;
import software.amazon.awssdk.services.sms.model.TerminateAppRequest;
import software.amazon.awssdk.services.sms.model.TerminateAppResponse;
import software.amazon.awssdk.services.sms.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.sms.model.UpdateAppRequest;
import software.amazon.awssdk.services.sms.model.UpdateAppResponse;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobResponse;
import software.amazon.awssdk.services.sms.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.CreateReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DisassociateConnectorRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GenerateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GenerateTemplateRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppValidationOutputRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetConnectorsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationJobsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationRunsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetServersRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportAppCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.LaunchAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.NotifyAppValidationOutputRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandReplicationRunRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StopAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.TerminateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateReplicationJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSmsClient
implements SmsClient {
    private static final Logger log = Logger.loggerFor(DefaultSmsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSmsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, createAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApp");
            CreateAppResponse createAppResponse = (CreateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$createApp$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationJobResponse createReplicationJob(CreateReplicationJobRequest createReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ServerCannotBeReplicatedException, ReplicationJobAlreadyExistsException, NoConnectorsAvailableException, InternalErrorException, TemporarilyUnavailableException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, createReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationJob");
            CreateReplicationJobResponse createReplicationJobResponse = (CreateReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReplicationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$createReplicationJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, deleteAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApp");
            DeleteAppResponse deleteAppResponse = (DeleteAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteApp$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppLaunchConfigurationResponse deleteAppLaunchConfiguration(DeleteAppLaunchConfigurationRequest deleteAppLaunchConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppLaunchConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, deleteAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppLaunchConfiguration");
            DeleteAppLaunchConfigurationResponse deleteAppLaunchConfigurationResponse = (DeleteAppLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAppLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteAppLaunchConfiguration$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppReplicationConfigurationResponse deleteAppReplicationConfiguration(DeleteAppReplicationConfigurationRequest deleteAppReplicationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppReplicationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, deleteAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppReplicationConfiguration");
            DeleteAppReplicationConfigurationResponse deleteAppReplicationConfigurationResponse = (DeleteAppReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAppReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteAppReplicationConfiguration$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppValidationConfigurationResponse deleteAppValidationConfiguration(DeleteAppValidationConfigurationRequest deleteAppValidationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppValidationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppValidationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, deleteAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppValidationConfiguration");
            DeleteAppValidationConfigurationResponse deleteAppValidationConfigurationResponse = (DeleteAppValidationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppValidationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAppValidationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppValidationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteAppValidationConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationJobResponse deleteReplicationJob(DeleteReplicationJobRequest deleteReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ReplicationJobNotFoundException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, deleteReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationJob");
            DeleteReplicationJobResponse deleteReplicationJobResponse = (DeleteReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteReplicationJob$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServerCatalogResponse deleteServerCatalog(DeleteServerCatalogRequest deleteServerCatalogRequest) throws UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServerCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServerCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, deleteServerCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServerCatalog");
            DeleteServerCatalogResponse deleteServerCatalogResponse = (DeleteServerCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServerCatalog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServerCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServerCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServerCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$deleteServerCatalog$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateConnectorResponse disassociateConnector(DisassociateConnectorRequest disassociateConnectorRequest) throws MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, disassociateConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateConnector");
            DisassociateConnectorResponse disassociateConnectorResponse = (DisassociateConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$disassociateConnector$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateChangeSetResponse generateChangeSet(GenerateChangeSetRequest generateChangeSetRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateChangeSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateChangeSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, generateChangeSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateChangeSet");
            GenerateChangeSetResponse generateChangeSetResponse = (GenerateChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateChangeSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateChangeSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateChangeSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateChangeSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$generateChangeSet$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateTemplateResponse generateTemplate(GenerateTemplateRequest generateTemplateRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, generateTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateTemplate");
            GenerateTemplateResponse generateTemplateResponse = (GenerateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$generateTemplate$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppResponse getApp(GetAppRequest getAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApp");
            GetAppResponse getAppResponse = (GetAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getApp$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppLaunchConfigurationResponse getAppLaunchConfiguration(GetAppLaunchConfigurationRequest getAppLaunchConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppLaunchConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppLaunchConfiguration");
            GetAppLaunchConfigurationResponse getAppLaunchConfigurationResponse = (GetAppLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppLaunchConfiguration$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppReplicationConfigurationResponse getAppReplicationConfiguration(GetAppReplicationConfigurationRequest getAppReplicationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppReplicationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppReplicationConfiguration");
            GetAppReplicationConfigurationResponse getAppReplicationConfigurationResponse = (GetAppReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppReplicationConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppValidationConfigurationResponse getAppValidationConfiguration(GetAppValidationConfigurationRequest getAppValidationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppValidationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppValidationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppValidationConfiguration");
            GetAppValidationConfigurationResponse getAppValidationConfigurationResponse = (GetAppValidationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppValidationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppValidationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppValidationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppValidationConfiguration$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppValidationOutputResponse getAppValidationOutput(GetAppValidationOutputRequest getAppValidationOutputRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppValidationOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppValidationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getAppValidationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppValidationOutput");
            GetAppValidationOutputResponse getAppValidationOutputResponse = (GetAppValidationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppValidationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppValidationOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppValidationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppValidationOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getAppValidationOutput$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConnectorsResponse getConnectors(GetConnectorsRequest getConnectorsRequest) throws UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnectors");
            GetConnectorsResponse getConnectorsResponse = (GetConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getConnectors$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReplicationJobsResponse getReplicationJobs(GetReplicationJobsRequest getReplicationJobsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReplicationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getReplicationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationJobs");
            GetReplicationJobsResponse getReplicationJobsResponse = (GetReplicationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReplicationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReplicationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReplicationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getReplicationJobs$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReplicationRunsResponse getReplicationRuns(GetReplicationRunsRequest getReplicationRunsRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationRunsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReplicationRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getReplicationRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationRuns");
            GetReplicationRunsResponse getReplicationRunsResponse = (GetReplicationRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReplicationRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReplicationRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReplicationRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getReplicationRuns$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServersResponse getServers(GetServersRequest getServersRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, getServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServers");
            GetServersResponse getServersResponse = (GetServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$getServers$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportAppCatalogResponse importAppCatalog(ImportAppCatalogRequest importAppCatalogRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportAppCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importAppCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, importAppCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportAppCatalog");
            ImportAppCatalogResponse importAppCatalogResponse = (ImportAppCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportAppCatalog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importAppCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportAppCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importAppCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$importAppCatalog$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportServerCatalogResponse importServerCatalog(ImportServerCatalogRequest importServerCatalogRequest) throws UnauthorizedOperationException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, NoConnectorsAvailableException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportServerCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importServerCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, importServerCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportServerCatalog");
            ImportServerCatalogResponse importServerCatalogResponse = (ImportServerCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportServerCatalog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importServerCatalogRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportServerCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importServerCatalogResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$importServerCatalog$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LaunchAppResponse launchApp(LaunchAppRequest launchAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LaunchAppResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)launchAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, launchAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LaunchApp");
            LaunchAppResponse launchAppResponse = (LaunchAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LaunchApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)launchAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LaunchAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return launchAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$launchApp$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, listAppsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApps");
            ListAppsResponse listAppsResponse = (ListAppsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAppsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$listApps$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyAppValidationOutputResponse notifyAppValidationOutput(NotifyAppValidationOutputRequest notifyAppValidationOutputRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyAppValidationOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyAppValidationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, notifyAppValidationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyAppValidationOutput");
            NotifyAppValidationOutputResponse notifyAppValidationOutputResponse = (NotifyAppValidationOutputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyAppValidationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)notifyAppValidationOutputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new NotifyAppValidationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyAppValidationOutputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$notifyAppValidationOutput$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppLaunchConfigurationResponse putAppLaunchConfiguration(PutAppLaunchConfigurationRequest putAppLaunchConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppLaunchConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAppLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, putAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppLaunchConfiguration");
            PutAppLaunchConfigurationResponse putAppLaunchConfigurationResponse = (PutAppLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAppLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$putAppLaunchConfiguration$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppReplicationConfigurationResponse putAppReplicationConfiguration(PutAppReplicationConfigurationRequest putAppReplicationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppReplicationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAppReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, putAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppReplicationConfiguration");
            PutAppReplicationConfigurationResponse putAppReplicationConfigurationResponse = (PutAppReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAppReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$putAppReplicationConfiguration$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppValidationConfigurationResponse putAppValidationConfiguration(PutAppValidationConfigurationRequest putAppValidationConfigurationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppValidationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAppValidationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, putAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppValidationConfiguration");
            PutAppValidationConfigurationResponse putAppValidationConfigurationResponse = (PutAppValidationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppValidationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAppValidationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppValidationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$putAppValidationConfiguration$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAppReplicationResponse startAppReplication(StartAppReplicationRequest startAppReplicationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAppReplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAppReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, startAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAppReplication");
            StartAppReplicationResponse startAppReplicationResponse = (StartAppReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAppReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startAppReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAppReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$startAppReplication$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartOnDemandAppReplicationResponse startOnDemandAppReplication(StartOnDemandAppReplicationRequest startOnDemandAppReplicationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOnDemandAppReplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startOnDemandAppReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, startOnDemandAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartOnDemandAppReplication");
            StartOnDemandAppReplicationResponse startOnDemandAppReplicationResponse = (StartOnDemandAppReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOnDemandAppReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startOnDemandAppReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartOnDemandAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startOnDemandAppReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$startOnDemandAppReplication$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartOnDemandReplicationRunResponse startOnDemandReplicationRun(StartOnDemandReplicationRunRequest startOnDemandReplicationRunRequest) throws InvalidParameterException, MissingRequiredParameterException, UnauthorizedOperationException, OperationNotPermittedException, ReplicationRunLimitExceededException, DryRunOperationException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOnDemandReplicationRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startOnDemandReplicationRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, startOnDemandReplicationRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartOnDemandReplicationRun");
            StartOnDemandReplicationRunResponse startOnDemandReplicationRunResponse = (StartOnDemandReplicationRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOnDemandReplicationRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startOnDemandReplicationRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartOnDemandReplicationRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startOnDemandReplicationRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$startOnDemandReplicationRun$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopAppReplicationResponse stopAppReplication(StopAppReplicationRequest stopAppReplicationRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopAppReplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopAppReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, stopAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopAppReplication");
            StopAppReplicationResponse stopAppReplicationResponse = (StopAppReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopAppReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopAppReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopAppReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$stopAppReplication$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateAppResponse terminateApp(TerminateAppRequest terminateAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateAppResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)terminateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, terminateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateApp");
            TerminateAppResponse terminateAppResponse = (TerminateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)terminateAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$terminateApp$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws UnauthorizedOperationException, InvalidParameterException, MissingRequiredParameterException, InternalErrorException, OperationNotPermittedException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, updateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApp");
            UpdateAppResponse updateAppResponse = (UpdateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$updateApp$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReplicationJobResponse updateReplicationJob(UpdateReplicationJobRequest updateReplicationJobRequest) throws InvalidParameterException, MissingRequiredParameterException, OperationNotPermittedException, UnauthorizedOperationException, ServerCannotBeReplicatedException, ReplicationJobNotFoundException, InternalErrorException, TemporarilyUnavailableException, AwsServiceException, SdkClientException, SmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "TemporarilyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "ReplicationJobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "InternalError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "ServerCannotBeReplicatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                }
                case "ReplicationRunLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "ReplicationJobAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                }
                case "NoConnectorsAvailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateReplicationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsClient.resolveMetricPublishers(clientConfiguration, updateReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationJob");
            UpdateReplicationJobResponse updateReplicationJobResponse = (UpdateReplicationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateReplicationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReplicationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSmsClient.lambda$updateReplicationJob$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "sms";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SmsServiceClientConfigurationBuilder serviceConfigBuilder = new SmsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SmsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final SmsServiceClientConfiguration serviceClientConfiguration() {
        return new SmsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateReplicationJob$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApp$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateApp$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopAppReplication$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startOnDemandReplicationRun$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startOnDemandAppReplication$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAppReplication$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppValidationConfiguration$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppReplicationConfiguration$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppLaunchConfiguration$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyAppValidationOutput$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApps$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$launchApp$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importServerCatalog$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importAppCatalog$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServers$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationRuns$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationJobs$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnectors$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppValidationOutput$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppValidationConfiguration$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppReplicationConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppLaunchConfiguration$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApp$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateTemplate$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateChangeSet$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateConnector$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServerCatalog$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationJob$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppValidationConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppReplicationConfiguration$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppLaunchConfiguration$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApp$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApp$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

