/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.S3Location;
import software.amazon.awssdk.services.sms.model.ScriptType;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.services.sms.model.UserData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerLaunchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerLaunchConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("server").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::server)).setter(ServerLaunchConfiguration.setter(Builder::server)).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()}).build();
    private static final SdkField<String> LOGICAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logicalId").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::logicalId)).setter(ServerLaunchConfiguration.setter(Builder::logicalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalId").build()}).build();
    private static final SdkField<String> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpc").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::vpc)).setter(ServerLaunchConfiguration.setter(Builder::vpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final SdkField<String> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subnet").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::subnet)).setter(ServerLaunchConfiguration.setter(Builder::subnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnet").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityGroup").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::securityGroup)).setter(ServerLaunchConfiguration.setter(Builder::securityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroup").build()}).build();
    private static final SdkField<String> EC2_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2KeyName").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::ec2KeyName)).setter(ServerLaunchConfiguration.setter(Builder::ec2KeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyName").build()}).build();
    private static final SdkField<UserData> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userData").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::userData)).setter(ServerLaunchConfiguration.setter(Builder::userData)).constructor(UserData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::instanceType)).setter(ServerLaunchConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("associatePublicIpAddress").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::associatePublicIpAddress)).setter(ServerLaunchConfiguration.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamInstanceProfileName").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::iamInstanceProfileName)).setter(ServerLaunchConfiguration.setter(Builder::iamInstanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileName").build()}).build();
    private static final SdkField<S3Location> CONFIGURE_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configureScript").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::configureScript)).setter(ServerLaunchConfiguration.setter(Builder::configureScript)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configureScript").build()}).build();
    private static final SdkField<String> CONFIGURE_SCRIPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configureScriptType").getter(ServerLaunchConfiguration.getter(ServerLaunchConfiguration::configureScriptTypeAsString)).setter(ServerLaunchConfiguration.setter(Builder::configureScriptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configureScriptType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD, LOGICAL_ID_FIELD, VPC_FIELD, SUBNET_FIELD, SECURITY_GROUP_FIELD, EC2_KEY_NAME_FIELD, USER_DATA_FIELD, INSTANCE_TYPE_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, IAM_INSTANCE_PROFILE_NAME_FIELD, CONFIGURE_SCRIPT_FIELD, CONFIGURE_SCRIPT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerLaunchConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Server server;
    private final String logicalId;
    private final String vpc;
    private final String subnet;
    private final String securityGroup;
    private final String ec2KeyName;
    private final UserData userData;
    private final String instanceType;
    private final Boolean associatePublicIpAddress;
    private final String iamInstanceProfileName;
    private final S3Location configureScript;
    private final String configureScriptType;

    private ServerLaunchConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.logicalId = builder.logicalId;
        this.vpc = builder.vpc;
        this.subnet = builder.subnet;
        this.securityGroup = builder.securityGroup;
        this.ec2KeyName = builder.ec2KeyName;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.iamInstanceProfileName = builder.iamInstanceProfileName;
        this.configureScript = builder.configureScript;
        this.configureScriptType = builder.configureScriptType;
    }

    public final Server server() {
        return this.server;
    }

    public final String logicalId() {
        return this.logicalId;
    }

    public final String vpc() {
        return this.vpc;
    }

    public final String subnet() {
        return this.subnet;
    }

    public final String securityGroup() {
        return this.securityGroup;
    }

    public final String ec2KeyName() {
        return this.ec2KeyName;
    }

    public final UserData userData() {
        return this.userData;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final String iamInstanceProfileName() {
        return this.iamInstanceProfileName;
    }

    public final S3Location configureScript() {
        return this.configureScript;
    }

    public final ScriptType configureScriptType() {
        return ScriptType.fromValue(this.configureScriptType);
    }

    public final String configureScriptTypeAsString() {
        return this.configureScriptType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.server());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configureScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.configureScriptTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerLaunchConfiguration)) {
            return false;
        }
        ServerLaunchConfiguration other = (ServerLaunchConfiguration)obj;
        return Objects.equals(this.server(), other.server()) && Objects.equals(this.logicalId(), other.logicalId()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.subnet(), other.subnet()) && Objects.equals(this.securityGroup(), other.securityGroup()) && Objects.equals(this.ec2KeyName(), other.ec2KeyName()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.iamInstanceProfileName(), other.iamInstanceProfileName()) && Objects.equals(this.configureScript(), other.configureScript()) && Objects.equals(this.configureScriptTypeAsString(), other.configureScriptTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServerLaunchConfiguration").add("Server", (Object)this.server()).add("LogicalId", (Object)this.logicalId()).add("Vpc", (Object)this.vpc()).add("Subnet", (Object)this.subnet()).add("SecurityGroup", (Object)this.securityGroup()).add("Ec2KeyName", (Object)this.ec2KeyName()).add("UserData", (Object)this.userData()).add("InstanceType", (Object)this.instanceType()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("IamInstanceProfileName", (Object)this.iamInstanceProfileName()).add("ConfigureScript", (Object)this.configureScript()).add("ConfigureScriptType", (Object)this.configureScriptTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "server": {
                return Optional.ofNullable(clazz.cast(this.server()));
            }
            case "logicalId": {
                return Optional.ofNullable(clazz.cast(this.logicalId()));
            }
            case "vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
            case "securityGroup": {
                return Optional.ofNullable(clazz.cast(this.securityGroup()));
            }
            case "ec2KeyName": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyName()));
            }
            case "userData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "associatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "iamInstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfileName()));
            }
            case "configureScript": {
                return Optional.ofNullable(clazz.cast(this.configureScript()));
            }
            case "configureScriptType": {
                return Optional.ofNullable(clazz.cast(this.configureScriptTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("server", SERVER_FIELD);
        map.put("logicalId", LOGICAL_ID_FIELD);
        map.put("vpc", VPC_FIELD);
        map.put("subnet", SUBNET_FIELD);
        map.put("securityGroup", SECURITY_GROUP_FIELD);
        map.put("ec2KeyName", EC2_KEY_NAME_FIELD);
        map.put("userData", USER_DATA_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("associatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("iamInstanceProfileName", IAM_INSTANCE_PROFILE_NAME_FIELD);
        map.put("configureScript", CONFIGURE_SCRIPT_FIELD);
        map.put("configureScriptType", CONFIGURE_SCRIPT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerLaunchConfiguration, T> g) {
        return obj -> g.apply((ServerLaunchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Server server;
        private String logicalId;
        private String vpc;
        private String subnet;
        private String securityGroup;
        private String ec2KeyName;
        private UserData userData;
        private String instanceType;
        private Boolean associatePublicIpAddress;
        private String iamInstanceProfileName;
        private S3Location configureScript;
        private String configureScriptType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerLaunchConfiguration model) {
            this.server(model.server);
            this.logicalId(model.logicalId);
            this.vpc(model.vpc);
            this.subnet(model.subnet);
            this.securityGroup(model.securityGroup);
            this.ec2KeyName(model.ec2KeyName);
            this.userData(model.userData);
            this.instanceType(model.instanceType);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.iamInstanceProfileName(model.iamInstanceProfileName);
            this.configureScript(model.configureScript);
            this.configureScriptType(model.configureScriptType);
        }

        public final Server.Builder getServer() {
            return this.server != null ? this.server.toBuilder() : null;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final String getLogicalId() {
            return this.logicalId;
        }

        public final void setLogicalId(String logicalId) {
            this.logicalId = logicalId;
        }

        @Override
        public final Builder logicalId(String logicalId) {
            this.logicalId = logicalId;
            return this;
        }

        public final String getVpc() {
            return this.vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getSubnet() {
            return this.subnet;
        }

        public final void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        @Override
        public final Builder subnet(String subnet) {
            this.subnet = subnet;
            return this;
        }

        public final String getSecurityGroup() {
            return this.securityGroup;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final UserData.Builder getUserData() {
            return this.userData != null ? this.userData.toBuilder() : null;
        }

        public final void setUserData(UserData.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final String getIamInstanceProfileName() {
            return this.iamInstanceProfileName;
        }

        public final void setIamInstanceProfileName(String iamInstanceProfileName) {
            this.iamInstanceProfileName = iamInstanceProfileName;
        }

        @Override
        public final Builder iamInstanceProfileName(String iamInstanceProfileName) {
            this.iamInstanceProfileName = iamInstanceProfileName;
            return this;
        }

        public final S3Location.Builder getConfigureScript() {
            return this.configureScript != null ? this.configureScript.toBuilder() : null;
        }

        public final void setConfigureScript(S3Location.BuilderImpl configureScript) {
            this.configureScript = configureScript != null ? configureScript.build() : null;
        }

        @Override
        public final Builder configureScript(S3Location configureScript) {
            this.configureScript = configureScript;
            return this;
        }

        public final String getConfigureScriptType() {
            return this.configureScriptType;
        }

        public final void setConfigureScriptType(String configureScriptType) {
            this.configureScriptType = configureScriptType;
        }

        @Override
        public final Builder configureScriptType(String configureScriptType) {
            this.configureScriptType = configureScriptType;
            return this;
        }

        @Override
        public final Builder configureScriptType(ScriptType configureScriptType) {
            this.configureScriptType(configureScriptType == null ? null : configureScriptType.toString());
            return this;
        }

        public ServerLaunchConfiguration build() {
            return new ServerLaunchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerLaunchConfiguration> {
        public Builder server(Server var1);

        default public Builder server(Consumer<Server.Builder> server) {
            return this.server((Server)((Server.Builder)Server.builder().applyMutation(server)).build());
        }

        public Builder logicalId(String var1);

        public Builder vpc(String var1);

        public Builder subnet(String var1);

        public Builder securityGroup(String var1);

        public Builder ec2KeyName(String var1);

        public Builder userData(UserData var1);

        default public Builder userData(Consumer<UserData.Builder> userData) {
            return this.userData((UserData)((UserData.Builder)UserData.builder().applyMutation(userData)).build());
        }

        public Builder instanceType(String var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder iamInstanceProfileName(String var1);

        public Builder configureScript(S3Location var1);

        default public Builder configureScript(Consumer<S3Location.Builder> configureScript) {
            return this.configureScript((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(configureScript)).build());
        }

        public Builder configureScriptType(String var1);

        public Builder configureScriptType(ScriptType var1);
    }
}

