/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.services.sms.model.ServerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerGroup> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverGroupId").getter(ServerGroup.getter(ServerGroup::serverGroupId)).setter(ServerGroup.setter(Builder::serverGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServerGroup.getter(ServerGroup::name)).setter(ServerGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Server>> SERVER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverList").getter(ServerGroup.getter(ServerGroup::serverList)).setter(ServerGroup.setter(Builder::serverList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD, NAME_FIELD, SERVER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverGroupId;
    private final String name;
    private final List<Server> serverList;

    private ServerGroup(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.name = builder.name;
        this.serverList = builder.serverList;
    }

    public final String serverGroupId() {
        return this.serverGroupId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasServerList() {
        return this.serverList != null && !(this.serverList instanceof SdkAutoConstructList);
    }

    public final List<Server> serverList() {
        return this.serverList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerList() ? this.serverList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroup)) {
            return false;
        }
        ServerGroup other = (ServerGroup)obj;
        return Objects.equals(this.serverGroupId(), other.serverGroupId()) && Objects.equals(this.name(), other.name()) && this.hasServerList() == other.hasServerList() && Objects.equals(this.serverList(), other.serverList());
    }

    public final String toString() {
        return ToString.builder((String)"ServerGroup").add("ServerGroupId", (Object)this.serverGroupId()).add("Name", (Object)this.name()).add("ServerList", this.hasServerList() ? this.serverList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverGroupId": {
                return Optional.ofNullable(clazz.cast(this.serverGroupId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serverList": {
                return Optional.ofNullable(clazz.cast(this.serverList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serverGroupId", SERVER_GROUP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serverList", SERVER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerGroup, T> g) {
        return obj -> g.apply((ServerGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverGroupId;
        private String name;
        private List<Server> serverList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroup model) {
            this.serverGroupId(model.serverGroupId);
            this.name(model.name);
            this.serverList(model.serverList);
        }

        public final String getServerGroupId() {
            return this.serverGroupId;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Server.Builder> getServerList() {
            List<Server.Builder> result = ServerListCopier.copyToBuilder(this.serverList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerList(Collection<Server.BuilderImpl> serverList) {
            this.serverList = ServerListCopier.copyFromBuilder(serverList);
        }

        @Override
        public final Builder serverList(Collection<Server> serverList) {
            this.serverList = ServerListCopier.copy(serverList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Server ... serverList) {
            this.serverList(Arrays.asList(serverList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Consumer<Server.Builder> ... serverList) {
            this.serverList(Stream.of(serverList).map(c -> (Server)((Server.Builder)Server.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServerGroup build() {
            return new ServerGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerGroup> {
        public Builder serverGroupId(String var1);

        public Builder name(String var1);

        public Builder serverList(Collection<Server> var1);

        public Builder serverList(Server ... var1);

        public Builder serverList(Consumer<Server.Builder> ... var1);
    }
}

