/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.AppValidationConfiguration;
import software.amazon.awssdk.services.sms.model.AppValidationConfigurationsCopier;
import software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration;
import software.amazon.awssdk.services.sms.model.ServerGroupValidationConfigurationsCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppValidationConfigurationResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetAppValidationConfigurationResponse> {
    private static final SdkField<List<AppValidationConfiguration>> APP_VALIDATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appValidationConfigurations").getter(GetAppValidationConfigurationResponse.getter(GetAppValidationConfigurationResponse::appValidationConfigurations)).setter(GetAppValidationConfigurationResponse.setter(Builder::appValidationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appValidationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppValidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServerGroupValidationConfiguration>> SERVER_GROUP_VALIDATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverGroupValidationConfigurations").getter(GetAppValidationConfigurationResponse.getter(GetAppValidationConfigurationResponse::serverGroupValidationConfigurations)).setter(GetAppValidationConfigurationResponse.setter(Builder::serverGroupValidationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupValidationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerGroupValidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VALIDATION_CONFIGURATIONS_FIELD, SERVER_GROUP_VALIDATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAppValidationConfigurationResponse.memberNameToFieldInitializer();
    private final List<AppValidationConfiguration> appValidationConfigurations;
    private final List<ServerGroupValidationConfiguration> serverGroupValidationConfigurations;

    private GetAppValidationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.appValidationConfigurations = builder.appValidationConfigurations;
        this.serverGroupValidationConfigurations = builder.serverGroupValidationConfigurations;
    }

    public final boolean hasAppValidationConfigurations() {
        return this.appValidationConfigurations != null && !(this.appValidationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AppValidationConfiguration> appValidationConfigurations() {
        return this.appValidationConfigurations;
    }

    public final boolean hasServerGroupValidationConfigurations() {
        return this.serverGroupValidationConfigurations != null && !(this.serverGroupValidationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServerGroupValidationConfiguration> serverGroupValidationConfigurations() {
        return this.serverGroupValidationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppValidationConfigurations() ? this.appValidationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerGroupValidationConfigurations() ? this.serverGroupValidationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppValidationConfigurationResponse)) {
            return false;
        }
        GetAppValidationConfigurationResponse other = (GetAppValidationConfigurationResponse)((Object)obj);
        return this.hasAppValidationConfigurations() == other.hasAppValidationConfigurations() && Objects.equals(this.appValidationConfigurations(), other.appValidationConfigurations()) && this.hasServerGroupValidationConfigurations() == other.hasServerGroupValidationConfigurations() && Objects.equals(this.serverGroupValidationConfigurations(), other.serverGroupValidationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"GetAppValidationConfigurationResponse").add("AppValidationConfigurations", this.hasAppValidationConfigurations() ? this.appValidationConfigurations() : null).add("ServerGroupValidationConfigurations", this.hasServerGroupValidationConfigurations() ? this.serverGroupValidationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appValidationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.appValidationConfigurations()));
            }
            case "serverGroupValidationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverGroupValidationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appValidationConfigurations", APP_VALIDATION_CONFIGURATIONS_FIELD);
        map.put("serverGroupValidationConfigurations", SERVER_GROUP_VALIDATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAppValidationConfigurationResponse, T> g) {
        return obj -> g.apply((GetAppValidationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private List<AppValidationConfiguration> appValidationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<ServerGroupValidationConfiguration> serverGroupValidationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppValidationConfigurationResponse model) {
            super(model);
            this.appValidationConfigurations(model.appValidationConfigurations);
            this.serverGroupValidationConfigurations(model.serverGroupValidationConfigurations);
        }

        public final List<AppValidationConfiguration.Builder> getAppValidationConfigurations() {
            List<AppValidationConfiguration.Builder> result = AppValidationConfigurationsCopier.copyToBuilder(this.appValidationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppValidationConfigurations(Collection<AppValidationConfiguration.BuilderImpl> appValidationConfigurations) {
            this.appValidationConfigurations = AppValidationConfigurationsCopier.copyFromBuilder(appValidationConfigurations);
        }

        @Override
        public final Builder appValidationConfigurations(Collection<AppValidationConfiguration> appValidationConfigurations) {
            this.appValidationConfigurations = AppValidationConfigurationsCopier.copy(appValidationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appValidationConfigurations(AppValidationConfiguration ... appValidationConfigurations) {
            this.appValidationConfigurations(Arrays.asList(appValidationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appValidationConfigurations(Consumer<AppValidationConfiguration.Builder> ... appValidationConfigurations) {
            this.appValidationConfigurations(Stream.of(appValidationConfigurations).map(c -> (AppValidationConfiguration)((AppValidationConfiguration.Builder)AppValidationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServerGroupValidationConfiguration.Builder> getServerGroupValidationConfigurations() {
            List<ServerGroupValidationConfiguration.Builder> result = ServerGroupValidationConfigurationsCopier.copyToBuilder(this.serverGroupValidationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerGroupValidationConfigurations(Collection<ServerGroupValidationConfiguration.BuilderImpl> serverGroupValidationConfigurations) {
            this.serverGroupValidationConfigurations = ServerGroupValidationConfigurationsCopier.copyFromBuilder(serverGroupValidationConfigurations);
        }

        @Override
        public final Builder serverGroupValidationConfigurations(Collection<ServerGroupValidationConfiguration> serverGroupValidationConfigurations) {
            this.serverGroupValidationConfigurations = ServerGroupValidationConfigurationsCopier.copy(serverGroupValidationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupValidationConfigurations(ServerGroupValidationConfiguration ... serverGroupValidationConfigurations) {
            this.serverGroupValidationConfigurations(Arrays.asList(serverGroupValidationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupValidationConfigurations(Consumer<ServerGroupValidationConfiguration.Builder> ... serverGroupValidationConfigurations) {
            this.serverGroupValidationConfigurations(Stream.of(serverGroupValidationConfigurations).map(c -> (ServerGroupValidationConfiguration)((ServerGroupValidationConfiguration.Builder)ServerGroupValidationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAppValidationConfigurationResponse build() {
            return new GetAppValidationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppValidationConfigurationResponse> {
        public Builder appValidationConfigurations(Collection<AppValidationConfiguration> var1);

        public Builder appValidationConfigurations(AppValidationConfiguration ... var1);

        public Builder appValidationConfigurations(Consumer<AppValidationConfiguration.Builder> ... var1);

        public Builder serverGroupValidationConfigurations(Collection<ServerGroupValidationConfiguration> var1);

        public Builder serverGroupValidationConfigurations(ServerGroupValidationConfiguration ... var1);

        public Builder serverGroupValidationConfigurations(Consumer<ServerGroupValidationConfiguration.Builder> ... var1);
    }
}

