/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.internal.UserAgentUtils;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.Server;

public class GetServersIterable
implements SdkIterable<GetServersResponse> {
    private final SmsClient client;
    private final GetServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetServersIterable(SmsClient client, GetServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetServersResponseFetcher();
    }

    public Iterator<GetServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Server> serverList() {
        Function<GetServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverList() != null) {
                return response.serverList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetServersResponseFetcher
    implements SyncPageFetcher<GetServersResponse> {
        private GetServersResponseFetcher() {
        }

        public boolean hasNextPage(GetServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetServersResponse nextPage(GetServersResponse previousPage) {
            if (previousPage == null) {
                return GetServersIterable.this.client.getServers(GetServersIterable.this.firstRequest);
            }
            return GetServersIterable.this.client.getServers((GetServersRequest)((Object)GetServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

