/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sms.DefaultSmsAsyncClient;
import software.amazon.awssdk.services.sms.DefaultSmsBaseClientBuilder;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.SmsAsyncClientBuilder;
import software.amazon.awssdk.services.sms.SmsServiceClientConfiguration;
import software.amazon.awssdk.services.sms.endpoints.SmsEndpointProvider;

@SdkInternalApi
final class DefaultSmsAsyncClientBuilder
extends DefaultSmsBaseClientBuilder<SmsAsyncClientBuilder, SmsAsyncClient>
implements SmsAsyncClientBuilder {
    DefaultSmsAsyncClientBuilder() {
    }

    @Override
    public DefaultSmsAsyncClientBuilder endpointProvider(SmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SmsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSmsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SmsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSmsAsyncClient client = new DefaultSmsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SmsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

