/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AppLaunchStatus {
    READY_FOR_CONFIGURATION("READY_FOR_CONFIGURATION"),

    CONFIGURATION_IN_PROGRESS("CONFIGURATION_IN_PROGRESS"),

    CONFIGURATION_INVALID("CONFIGURATION_INVALID"),

    READY_FOR_LAUNCH("READY_FOR_LAUNCH"),

    VALIDATION_IN_PROGRESS("VALIDATION_IN_PROGRESS"),

    LAUNCH_PENDING("LAUNCH_PENDING"),

    LAUNCH_IN_PROGRESS("LAUNCH_IN_PROGRESS"),

    LAUNCHED("LAUNCHED"),

    PARTIALLY_LAUNCHED("PARTIALLY_LAUNCHED"),

    DELTA_LAUNCH_IN_PROGRESS("DELTA_LAUNCH_IN_PROGRESS"),

    DELTA_LAUNCH_FAILED("DELTA_LAUNCH_FAILED"),

    LAUNCH_FAILED("LAUNCH_FAILED"),

    TERMINATE_IN_PROGRESS("TERMINATE_IN_PROGRESS"),

    TERMINATE_FAILED("TERMINATE_FAILED"),

    TERMINATED("TERMINATED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppLaunchStatus> VALUE_MAP = EnumUtils.uniqueIndex(AppLaunchStatus.class,
            AppLaunchStatus::toString);

    private final String value;

    private AppLaunchStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AppLaunchStatus corresponding to the value
     */
    public static AppLaunchStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AppLaunchStatus}s
     */
    public static Set<AppLaunchStatus> knownValues() {
        Set<AppLaunchStatus> knownValues = EnumSet.allOf(AppLaunchStatus.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
