/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sms.DefaultSmsAsyncClient;
import software.amazon.awssdk.services.sms.DefaultSmsBaseClientBuilder;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.SmsAsyncClientBuilder;
import software.amazon.awssdk.services.sms.SmsServiceClientConfiguration;
import software.amazon.awssdk.services.sms.endpoints.SmsEndpointProvider;

@SdkInternalApi
final class DefaultSmsAsyncClientBuilder
extends DefaultSmsBaseClientBuilder<SmsAsyncClientBuilder, SmsAsyncClient>
implements SmsAsyncClientBuilder {
    DefaultSmsAsyncClientBuilder() {
    }

    @Override
    public DefaultSmsAsyncClientBuilder endpointProvider(SmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SmsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSmsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SmsServiceClientConfiguration serviceClientConfiguration = SmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSmsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

