/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sms.DefaultSmsBaseClientBuilder;
import software.amazon.awssdk.services.sms.DefaultSmsClient;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.SmsClientBuilder;
import software.amazon.awssdk.services.sms.SmsServiceClientConfiguration;
import software.amazon.awssdk.services.sms.endpoints.SmsEndpointProvider;

@SdkInternalApi
final class DefaultSmsClientBuilder
extends DefaultSmsBaseClientBuilder<SmsClientBuilder, SmsClient>
implements SmsClientBuilder {
    DefaultSmsClientBuilder() {
    }

    @Override
    public DefaultSmsClientBuilder endpointProvider(SmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SmsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSmsClientBuilder.validateClientOptions(clientConfiguration);
        SmsServiceClientConfiguration serviceClientConfiguration = SmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultSmsClient(serviceClientConfiguration, clientConfiguration);
    }
}

