/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration;
import software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfigurationsCopier;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAppReplicationConfigurationRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, PutAppReplicationConfigurationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(PutAppReplicationConfigurationRequest.getter(PutAppReplicationConfigurationRequest::appId)).setter(PutAppReplicationConfigurationRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<List<ServerGroupReplicationConfiguration>> SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverGroupReplicationConfigurations").getter(PutAppReplicationConfigurationRequest.getter(PutAppReplicationConfigurationRequest::serverGroupReplicationConfigurations)).setter(PutAppReplicationConfigurationRequest.setter(Builder::serverGroupReplicationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupReplicationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerGroupReplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD));
    private final String appId;
    private final List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations;

    private PutAppReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.serverGroupReplicationConfigurations = builder.serverGroupReplicationConfigurations;
    }

    public final String appId() {
        return this.appId;
    }

    public final boolean hasServerGroupReplicationConfigurations() {
        return this.serverGroupReplicationConfigurations != null && !(this.serverGroupReplicationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations() {
        return this.serverGroupReplicationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerGroupReplicationConfigurations() ? this.serverGroupReplicationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppReplicationConfigurationRequest)) {
            return false;
        }
        PutAppReplicationConfigurationRequest other = (PutAppReplicationConfigurationRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && this.hasServerGroupReplicationConfigurations() == other.hasServerGroupReplicationConfigurations() && Objects.equals(this.serverGroupReplicationConfigurations(), other.serverGroupReplicationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"PutAppReplicationConfigurationRequest").add("AppId", (Object)this.appId()).add("ServerGroupReplicationConfigurations", this.hasServerGroupReplicationConfigurations() ? this.serverGroupReplicationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "serverGroupReplicationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverGroupReplicationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((PutAppReplicationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String appId;
        private List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppReplicationConfigurationRequest model) {
            super(model);
            this.appId(model.appId);
            this.serverGroupReplicationConfigurations(model.serverGroupReplicationConfigurations);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final List<ServerGroupReplicationConfiguration.Builder> getServerGroupReplicationConfigurations() {
            List<ServerGroupReplicationConfiguration.Builder> result = ServerGroupReplicationConfigurationsCopier.copyToBuilder(this.serverGroupReplicationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerGroupReplicationConfigurations(Collection<ServerGroupReplicationConfiguration.BuilderImpl> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier.copyFromBuilder(serverGroupReplicationConfigurations);
        }

        @Override
        @Transient
        public final Builder serverGroupReplicationConfigurations(Collection<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier.copy(serverGroupReplicationConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(ServerGroupReplicationConfiguration ... serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations(Arrays.asList(serverGroupReplicationConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(Consumer<ServerGroupReplicationConfiguration.Builder> ... serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations(Stream.of(serverGroupReplicationConfigurations).map(c -> (ServerGroupReplicationConfiguration)((ServerGroupReplicationConfiguration.Builder)ServerGroupReplicationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppReplicationConfigurationRequest build() {
            return new PutAppReplicationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAppReplicationConfigurationRequest> {
        public Builder appId(String var1);

        public Builder serverGroupReplicationConfigurations(Collection<ServerGroupReplicationConfiguration> var1);

        public Builder serverGroupReplicationConfigurations(ServerGroupReplicationConfiguration ... var1);

        public Builder serverGroupReplicationConfigurations(Consumer<ServerGroupReplicationConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

