/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.AppValidationOutput;
import software.amazon.awssdk.services.sms.model.ServerValidationOutput;
import software.amazon.awssdk.services.sms.model.ValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationOutput> {
    private static final SdkField<String> VALIDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationId").getter(ValidationOutput.getter(ValidationOutput::validationId)).setter(ValidationOutput.setter(Builder::validationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ValidationOutput.getter(ValidationOutput::name)).setter(ValidationOutput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ValidationOutput.getter(ValidationOutput::statusAsString)).setter(ValidationOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ValidationOutput.getter(ValidationOutput::statusMessage)).setter(ValidationOutput.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> LATEST_VALIDATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("latestValidationTime").getter(ValidationOutput.getter(ValidationOutput::latestValidationTime)).setter(ValidationOutput.setter(Builder::latestValidationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestValidationTime").build()}).build();
    private static final SdkField<AppValidationOutput> APP_VALIDATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appValidationOutput").getter(ValidationOutput.getter(ValidationOutput::appValidationOutput)).setter(ValidationOutput.setter(Builder::appValidationOutput)).constructor(AppValidationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appValidationOutput").build()}).build();
    private static final SdkField<ServerValidationOutput> SERVER_VALIDATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverValidationOutput").getter(ValidationOutput.getter(ValidationOutput::serverValidationOutput)).setter(ValidationOutput.setter(Builder::serverValidationOutput)).constructor(ServerValidationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidationOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ID_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, LATEST_VALIDATION_TIME_FIELD, APP_VALIDATION_OUTPUT_FIELD, SERVER_VALIDATION_OUTPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String validationId;
    private final String name;
    private final String status;
    private final String statusMessage;
    private final Instant latestValidationTime;
    private final AppValidationOutput appValidationOutput;
    private final ServerValidationOutput serverValidationOutput;

    private ValidationOutput(BuilderImpl builder) {
        this.validationId = builder.validationId;
        this.name = builder.name;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.latestValidationTime = builder.latestValidationTime;
        this.appValidationOutput = builder.appValidationOutput;
        this.serverValidationOutput = builder.serverValidationOutput;
    }

    public final String validationId() {
        return this.validationId;
    }

    public final String name() {
        return this.name;
    }

    public final ValidationStatus status() {
        return ValidationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant latestValidationTime() {
        return this.latestValidationTime;
    }

    public final AppValidationOutput appValidationOutput() {
        return this.appValidationOutput;
    }

    public final ServerValidationOutput serverValidationOutput() {
        return this.serverValidationOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestValidationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.appValidationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverValidationOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationOutput)) {
            return false;
        }
        ValidationOutput other = (ValidationOutput)obj;
        return Objects.equals(this.validationId(), other.validationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.latestValidationTime(), other.latestValidationTime()) && Objects.equals(this.appValidationOutput(), other.appValidationOutput()) && Objects.equals(this.serverValidationOutput(), other.serverValidationOutput());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationOutput").add("ValidationId", (Object)this.validationId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("LatestValidationTime", (Object)this.latestValidationTime()).add("AppValidationOutput", (Object)this.appValidationOutput()).add("ServerValidationOutput", (Object)this.serverValidationOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationId": {
                return Optional.ofNullable(clazz.cast(this.validationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "latestValidationTime": {
                return Optional.ofNullable(clazz.cast(this.latestValidationTime()));
            }
            case "appValidationOutput": {
                return Optional.ofNullable(clazz.cast(this.appValidationOutput()));
            }
            case "serverValidationOutput": {
                return Optional.ofNullable(clazz.cast(this.serverValidationOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationOutput, T> g) {
        return obj -> g.apply((ValidationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String validationId;
        private String name;
        private String status;
        private String statusMessage;
        private Instant latestValidationTime;
        private AppValidationOutput appValidationOutput;
        private ServerValidationOutput serverValidationOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationOutput model) {
            this.validationId(model.validationId);
            this.name(model.name);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.latestValidationTime(model.latestValidationTime);
            this.appValidationOutput(model.appValidationOutput);
            this.serverValidationOutput(model.serverValidationOutput);
        }

        public final String getValidationId() {
            return this.validationId;
        }

        public final void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        @Override
        @Transient
        public final Builder validationId(String validationId) {
            this.validationId = validationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ValidationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getLatestValidationTime() {
            return this.latestValidationTime;
        }

        public final void setLatestValidationTime(Instant latestValidationTime) {
            this.latestValidationTime = latestValidationTime;
        }

        @Override
        @Transient
        public final Builder latestValidationTime(Instant latestValidationTime) {
            this.latestValidationTime = latestValidationTime;
            return this;
        }

        public final AppValidationOutput.Builder getAppValidationOutput() {
            return this.appValidationOutput != null ? this.appValidationOutput.toBuilder() : null;
        }

        public final void setAppValidationOutput(AppValidationOutput.BuilderImpl appValidationOutput) {
            this.appValidationOutput = appValidationOutput != null ? appValidationOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder appValidationOutput(AppValidationOutput appValidationOutput) {
            this.appValidationOutput = appValidationOutput;
            return this;
        }

        public final ServerValidationOutput.Builder getServerValidationOutput() {
            return this.serverValidationOutput != null ? this.serverValidationOutput.toBuilder() : null;
        }

        public final void setServerValidationOutput(ServerValidationOutput.BuilderImpl serverValidationOutput) {
            this.serverValidationOutput = serverValidationOutput != null ? serverValidationOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder serverValidationOutput(ServerValidationOutput serverValidationOutput) {
            this.serverValidationOutput = serverValidationOutput;
            return this;
        }

        public ValidationOutput build() {
            return new ValidationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationOutput> {
        public Builder validationId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ValidationStatus var1);

        public Builder statusMessage(String var1);

        public Builder latestValidationTime(Instant var1);

        public Builder appValidationOutput(AppValidationOutput var1);

        default public Builder appValidationOutput(Consumer<AppValidationOutput.Builder> appValidationOutput) {
            return this.appValidationOutput((AppValidationOutput)((AppValidationOutput.Builder)AppValidationOutput.builder().applyMutation(appValidationOutput)).build());
        }

        public Builder serverValidationOutput(ServerValidationOutput var1);

        default public Builder serverValidationOutput(Consumer<ServerValidationOutput.Builder> serverValidationOutput) {
            return this.serverValidationOutput((ServerValidationOutput)((ServerValidationOutput.Builder)ServerValidationOutput.builder().applyMutation(serverValidationOutput)).build());
        }
    }
}

