/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.services.sms.model.VmServerAddress;
import software.amazon.awssdk.services.sms.model.VmServerAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServersRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, GetServersRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetServersRequest.getter(GetServersRequest::nextToken)).setter(GetServersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetServersRequest.getter(GetServersRequest::maxResults)).setter(GetServersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<VmServerAddress>> VM_SERVER_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vmServerAddressList").getter(GetServersRequest.getter(GetServersRequest::vmServerAddressList)).setter(GetServersRequest.setter(Builder::vmServerAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServerAddressList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VmServerAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, VM_SERVER_ADDRESS_LIST_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final List<VmServerAddress> vmServerAddressList;

    private GetServersRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.vmServerAddressList = builder.vmServerAddressList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasVmServerAddressList() {
        return this.vmServerAddressList != null && !(this.vmServerAddressList instanceof SdkAutoConstructList);
    }

    public final List<VmServerAddress> vmServerAddressList() {
        return this.vmServerAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVmServerAddressList() ? this.vmServerAddressList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServersRequest)) {
            return false;
        }
        GetServersRequest other = (GetServersRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasVmServerAddressList() == other.hasVmServerAddressList() && Objects.equals(this.vmServerAddressList(), other.vmServerAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"GetServersRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("VmServerAddressList", this.hasVmServerAddressList() ? this.vmServerAddressList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "vmServerAddressList": {
                return Optional.ofNullable(clazz.cast(this.vmServerAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServersRequest, T> g) {
        return obj -> g.apply((GetServersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<VmServerAddress> vmServerAddressList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServersRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.vmServerAddressList(model.vmServerAddressList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final List<VmServerAddress.Builder> getVmServerAddressList() {
            List<VmServerAddress.Builder> result = VmServerAddressListCopier.copyToBuilder(this.vmServerAddressList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vmServerAddressList(Collection<VmServerAddress> vmServerAddressList) {
            this.vmServerAddressList = VmServerAddressListCopier.copy(vmServerAddressList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmServerAddressList(VmServerAddress ... vmServerAddressList) {
            this.vmServerAddressList(Arrays.asList(vmServerAddressList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmServerAddressList(Consumer<VmServerAddress.Builder> ... vmServerAddressList) {
            this.vmServerAddressList(Stream.of(vmServerAddressList).map(c -> (VmServerAddress)((VmServerAddress.Builder)VmServerAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVmServerAddressList(Collection<VmServerAddress.BuilderImpl> vmServerAddressList) {
            this.vmServerAddressList = VmServerAddressListCopier.copyFromBuilder(vmServerAddressList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServersRequest build() {
            return new GetServersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServersRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder vmServerAddressList(Collection<VmServerAddress> var1);

        public Builder vmServerAddressList(VmServerAddress ... var1);

        public Builder vmServerAddressList(Consumer<VmServerAddress.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

