/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScriptType {
    SHELL_SCRIPT("SHELL_SCRIPT"),
    POWERSHELL_SCRIPT("POWERSHELL_SCRIPT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScriptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScriptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScriptType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScriptType> knownValues() {
        return Stream.of(ScriptType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

