/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.ScriptType;
import software.amazon.awssdk.services.sms.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserDataValidationParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserDataValidationParameters> {
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(UserDataValidationParameters.getter(UserDataValidationParameters::source)).setter(UserDataValidationParameters.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> SCRIPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptType").getter(UserDataValidationParameters.getter(UserDataValidationParameters::scriptTypeAsString)).setter(UserDataValidationParameters.setter(Builder::scriptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, SCRIPT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Source source;
    private final String scriptType;

    private UserDataValidationParameters(BuilderImpl builder) {
        this.source = builder.source;
        this.scriptType = builder.scriptType;
    }

    public Source source() {
        return this.source;
    }

    public ScriptType scriptType() {
        return ScriptType.fromValue(this.scriptType);
    }

    public String scriptTypeAsString() {
        return this.scriptType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDataValidationParameters)) {
            return false;
        }
        UserDataValidationParameters other = (UserDataValidationParameters)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.scriptTypeAsString(), other.scriptTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UserDataValidationParameters").add("Source", (Object)this.source()).add("ScriptType", (Object)this.scriptTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "scriptType": {
                return Optional.ofNullable(clazz.cast(this.scriptTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDataValidationParameters, T> g) {
        return obj -> g.apply((UserDataValidationParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Source source;
        private String scriptType;

        private BuilderImpl() {
        }

        private BuilderImpl(UserDataValidationParameters model) {
            this.source(model.source);
            this.scriptType(model.scriptType);
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getScriptType() {
            return this.scriptType;
        }

        @Override
        public final Builder scriptType(String scriptType) {
            this.scriptType = scriptType;
            return this;
        }

        @Override
        public final Builder scriptType(ScriptType scriptType) {
            this.scriptType(scriptType == null ? null : scriptType.toString());
            return this;
        }

        public final void setScriptType(String scriptType) {
            this.scriptType = scriptType;
        }

        public UserDataValidationParameters build() {
            return new UserDataValidationParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserDataValidationParameters> {
        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder scriptType(String var1);

        public Builder scriptType(ScriptType var1);
    }
}

