/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration;
import software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfigurationsCopier;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAppLaunchConfigurationRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, PutAppLaunchConfigurationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutAppLaunchConfigurationRequest.getter(PutAppLaunchConfigurationRequest::appId)).setter(PutAppLaunchConfigurationRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutAppLaunchConfigurationRequest.getter(PutAppLaunchConfigurationRequest::roleName)).setter(PutAppLaunchConfigurationRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<Boolean> AUTO_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PutAppLaunchConfigurationRequest.getter(PutAppLaunchConfigurationRequest::autoLaunch)).setter(PutAppLaunchConfigurationRequest.setter(Builder::autoLaunch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoLaunch").build()}).build();
    private static final SdkField<List<ServerGroupLaunchConfiguration>> SERVER_GROUP_LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutAppLaunchConfigurationRequest.getter(PutAppLaunchConfigurationRequest::serverGroupLaunchConfigurations)).setter(PutAppLaunchConfigurationRequest.setter(Builder::serverGroupLaunchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupLaunchConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerGroupLaunchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ROLE_NAME_FIELD, AUTO_LAUNCH_FIELD, SERVER_GROUP_LAUNCH_CONFIGURATIONS_FIELD));
    private final String appId;
    private final String roleName;
    private final Boolean autoLaunch;
    private final List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations;

    private PutAppLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.roleName = builder.roleName;
        this.autoLaunch = builder.autoLaunch;
        this.serverGroupLaunchConfigurations = builder.serverGroupLaunchConfigurations;
    }

    public String appId() {
        return this.appId;
    }

    public String roleName() {
        return this.roleName;
    }

    public Boolean autoLaunch() {
        return this.autoLaunch;
    }

    public boolean hasServerGroupLaunchConfigurations() {
        return this.serverGroupLaunchConfigurations != null && !(this.serverGroupLaunchConfigurations instanceof SdkAutoConstructList);
    }

    public List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations() {
        return this.serverGroupLaunchConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupLaunchConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppLaunchConfigurationRequest)) {
            return false;
        }
        PutAppLaunchConfigurationRequest other = (PutAppLaunchConfigurationRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.autoLaunch(), other.autoLaunch()) && Objects.equals(this.serverGroupLaunchConfigurations(), other.serverGroupLaunchConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"PutAppLaunchConfigurationRequest").add("AppId", (Object)this.appId()).add("RoleName", (Object)this.roleName()).add("AutoLaunch", (Object)this.autoLaunch()).add("ServerGroupLaunchConfigurations", this.serverGroupLaunchConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "autoLaunch": {
                return Optional.ofNullable(clazz.cast(this.autoLaunch()));
            }
            case "serverGroupLaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverGroupLaunchConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((PutAppLaunchConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String roleName;
        private Boolean autoLaunch;
        private List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppLaunchConfigurationRequest model) {
            super(model);
            this.appId(model.appId);
            this.roleName(model.roleName);
            this.autoLaunch(model.autoLaunch);
            this.serverGroupLaunchConfigurations(model.serverGroupLaunchConfigurations);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final Boolean getAutoLaunch() {
            return this.autoLaunch;
        }

        @Override
        public final Builder autoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
            return this;
        }

        public final void setAutoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
        }

        public final Collection<ServerGroupLaunchConfiguration.Builder> getServerGroupLaunchConfigurations() {
            return this.serverGroupLaunchConfigurations != null ? (Collection)this.serverGroupLaunchConfigurations.stream().map(ServerGroupLaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations = ServerGroupLaunchConfigurationsCopier.copy(serverGroupLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupLaunchConfigurations(ServerGroupLaunchConfiguration ... serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations(Arrays.asList(serverGroupLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupLaunchConfigurations(Consumer<ServerGroupLaunchConfiguration.Builder> ... serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations(Stream.of(serverGroupLaunchConfigurations).map(c -> (ServerGroupLaunchConfiguration)((ServerGroupLaunchConfiguration.Builder)ServerGroupLaunchConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration.BuilderImpl> serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations = ServerGroupLaunchConfigurationsCopier.copyFromBuilder(serverGroupLaunchConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppLaunchConfigurationRequest build() {
            return new PutAppLaunchConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAppLaunchConfigurationRequest> {
        public Builder appId(String var1);

        public Builder roleName(String var1);

        public Builder autoLaunch(Boolean var1);

        public Builder serverGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration> var1);

        public Builder serverGroupLaunchConfigurations(ServerGroupLaunchConfiguration ... var1);

        public Builder serverGroupLaunchConfigurations(Consumer<ServerGroupLaunchConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

