/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.LicenseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerReplicationParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerReplicationParameters> {
    private static final SdkField<Instant> SEED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ServerReplicationParameters.getter(ServerReplicationParameters::seedTime)).setter(ServerReplicationParameters.setter(Builder::seedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedTime").build()}).build();
    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ServerReplicationParameters.getter(ServerReplicationParameters::frequency)).setter(ServerReplicationParameters.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<Boolean> RUN_ONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ServerReplicationParameters.getter(ServerReplicationParameters::runOnce)).setter(ServerReplicationParameters.setter(Builder::runOnce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOnce").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerReplicationParameters.getter(ServerReplicationParameters::licenseTypeAsString)).setter(ServerReplicationParameters.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ServerReplicationParameters.getter(ServerReplicationParameters::numberOfRecentAmisToKeep)).setter(ServerReplicationParameters.setter(Builder::numberOfRecentAmisToKeep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecentAmisToKeep").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ServerReplicationParameters.getter(ServerReplicationParameters::encrypted)).setter(ServerReplicationParameters.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerReplicationParameters.getter(ServerReplicationParameters::kmsKeyId)).setter(ServerReplicationParameters.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_TIME_FIELD, FREQUENCY_FIELD, RUN_ONCE_FIELD, LICENSE_TYPE_FIELD, NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant seedTime;
    private final Integer frequency;
    private final Boolean runOnce;
    private final String licenseType;
    private final Integer numberOfRecentAmisToKeep;
    private final Boolean encrypted;
    private final String kmsKeyId;

    private ServerReplicationParameters(BuilderImpl builder) {
        this.seedTime = builder.seedTime;
        this.frequency = builder.frequency;
        this.runOnce = builder.runOnce;
        this.licenseType = builder.licenseType;
        this.numberOfRecentAmisToKeep = builder.numberOfRecentAmisToKeep;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public Instant seedTime() {
        return this.seedTime;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public Boolean runOnce() {
        return this.runOnce;
    }

    public LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public String licenseTypeAsString() {
        return this.licenseType;
    }

    public Integer numberOfRecentAmisToKeep() {
        return this.numberOfRecentAmisToKeep;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.seedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.runOnce());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecentAmisToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerReplicationParameters)) {
            return false;
        }
        ServerReplicationParameters other = (ServerReplicationParameters)obj;
        return Objects.equals(this.seedTime(), other.seedTime()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.runOnce(), other.runOnce()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.numberOfRecentAmisToKeep(), other.numberOfRecentAmisToKeep()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"ServerReplicationParameters").add("SeedTime", (Object)this.seedTime()).add("Frequency", (Object)this.frequency()).add("RunOnce", (Object)this.runOnce()).add("LicenseType", (Object)this.licenseTypeAsString()).add("NumberOfRecentAmisToKeep", (Object)this.numberOfRecentAmisToKeep()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "seedTime": {
                return Optional.ofNullable(clazz.cast(this.seedTime()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "runOnce": {
                return Optional.ofNullable(clazz.cast(this.runOnce()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "numberOfRecentAmisToKeep": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecentAmisToKeep()));
            }
            case "encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerReplicationParameters, T> g) {
        return obj -> g.apply((ServerReplicationParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant seedTime;
        private Integer frequency;
        private Boolean runOnce;
        private String licenseType;
        private Integer numberOfRecentAmisToKeep;
        private Boolean encrypted;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerReplicationParameters model) {
            this.seedTime(model.seedTime);
            this.frequency(model.frequency);
            this.runOnce(model.runOnce);
            this.licenseType(model.licenseType);
            this.numberOfRecentAmisToKeep(model.numberOfRecentAmisToKeep);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Instant getSeedTime() {
            return this.seedTime;
        }

        @Override
        public final Builder seedTime(Instant seedTime) {
            this.seedTime = seedTime;
            return this;
        }

        public final void setSeedTime(Instant seedTime) {
            this.seedTime = seedTime;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Boolean getRunOnce() {
            return this.runOnce;
        }

        @Override
        public final Builder runOnce(Boolean runOnce) {
            this.runOnce = runOnce;
            return this;
        }

        public final void setRunOnce(Boolean runOnce) {
            this.runOnce = runOnce;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final Integer getNumberOfRecentAmisToKeep() {
            return this.numberOfRecentAmisToKeep;
        }

        @Override
        public final Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
            return this;
        }

        public final void setNumberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public ServerReplicationParameters build() {
            return new ServerReplicationParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerReplicationParameters> {
        public Builder seedTime(Instant var1);

        public Builder frequency(Integer var1);

        public Builder runOnce(Boolean var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder numberOfRecentAmisToKeep(Integer var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);
    }
}

