/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.OutputFormat;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateTemplateRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, GenerateTemplateRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateTemplateRequest.getter(GenerateTemplateRequest::appId)).setter(GenerateTemplateRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> TEMPLATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateTemplateRequest.getter(GenerateTemplateRequest::templateFormatAsString)).setter(GenerateTemplateRequest.setter(Builder::templateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, TEMPLATE_FORMAT_FIELD));
    private final String appId;
    private final String templateFormat;

    private GenerateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.templateFormat = builder.templateFormat;
    }

    public String appId() {
        return this.appId;
    }

    public OutputFormat templateFormat() {
        return OutputFormat.fromValue(this.templateFormat);
    }

    public String templateFormatAsString() {
        return this.templateFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateFormatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateTemplateRequest)) {
            return false;
        }
        GenerateTemplateRequest other = (GenerateTemplateRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.templateFormatAsString(), other.templateFormatAsString());
    }

    public String toString() {
        return ToString.builder((String)"GenerateTemplateRequest").add("AppId", (Object)this.appId()).add("TemplateFormat", (Object)this.templateFormatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "templateFormat": {
                return Optional.ofNullable(clazz.cast(this.templateFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateTemplateRequest, T> g) {
        return obj -> g.apply((GenerateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String templateFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateTemplateRequest model) {
            super(model);
            this.appId(model.appId);
            this.templateFormat(model.templateFormat);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getTemplateFormatAsString() {
            return this.templateFormat;
        }

        @Override
        public final Builder templateFormat(String templateFormat) {
            this.templateFormat = templateFormat;
            return this;
        }

        @Override
        public final Builder templateFormat(OutputFormat templateFormat) {
            this.templateFormat(templateFormat == null ? null : templateFormat.toString());
            return this;
        }

        public final void setTemplateFormat(String templateFormat) {
            this.templateFormat = templateFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateTemplateRequest build() {
            return new GenerateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateTemplateRequest> {
        public Builder appId(String var1);

        public Builder templateFormat(String var1);

        public Builder templateFormat(OutputFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

