/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.LicenseType;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationJobRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, UpdateReplicationJobRequest> {
    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::replicationJobId)).setter(UpdateReplicationJobRequest.setter(Builder::replicationJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()}).build();
    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::frequency)).setter(UpdateReplicationJobRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<Instant> NEXT_REPLICATION_RUN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::nextReplicationRunStartTime)).setter(UpdateReplicationJobRequest.setter(Builder::nextReplicationRunStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextReplicationRunStartTime").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::licenseTypeAsString)).setter(UpdateReplicationJobRequest.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::roleName)).setter(UpdateReplicationJobRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::description)).setter(UpdateReplicationJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_ID_FIELD, FREQUENCY_FIELD, NEXT_REPLICATION_RUN_START_TIME_FIELD, LICENSE_TYPE_FIELD, ROLE_NAME_FIELD, DESCRIPTION_FIELD));
    private final String replicationJobId;
    private final Integer frequency;
    private final Instant nextReplicationRunStartTime;
    private final String licenseType;
    private final String roleName;
    private final String description;

    private UpdateReplicationJobRequest(BuilderImpl builder) {
        super(builder);
        this.replicationJobId = builder.replicationJobId;
        this.frequency = builder.frequency;
        this.nextReplicationRunStartTime = builder.nextReplicationRunStartTime;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.description = builder.description;
    }

    public String replicationJobId() {
        return this.replicationJobId;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public Instant nextReplicationRunStartTime() {
        return this.nextReplicationRunStartTime;
    }

    public LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public String licenseTypeAsString() {
        return this.licenseType;
    }

    public String roleName() {
        return this.roleName;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextReplicationRunStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationJobRequest)) {
            return false;
        }
        UpdateReplicationJobRequest other = (UpdateReplicationJobRequest)((Object)obj);
        return Objects.equals(this.replicationJobId(), other.replicationJobId()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.nextReplicationRunStartTime(), other.nextReplicationRunStartTime()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"UpdateReplicationJobRequest").add("ReplicationJobId", (Object)this.replicationJobId()).add("Frequency", (Object)this.frequency()).add("NextReplicationRunStartTime", (Object)this.nextReplicationRunStartTime()).add("LicenseType", (Object)this.licenseTypeAsString()).add("RoleName", (Object)this.roleName()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationJobId": {
                return Optional.ofNullable(clazz.cast(this.replicationJobId()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "nextReplicationRunStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextReplicationRunStartTime()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationJobRequest, T> g) {
        return obj -> g.apply((UpdateReplicationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String replicationJobId;
        private Integer frequency;
        private Instant nextReplicationRunStartTime;
        private String licenseType;
        private String roleName;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationJobRequest model) {
            super(model);
            this.replicationJobId(model.replicationJobId);
            this.frequency(model.frequency);
            this.nextReplicationRunStartTime(model.nextReplicationRunStartTime);
            this.licenseType(model.licenseType);
            this.roleName(model.roleName);
            this.description(model.description);
        }

        public final String getReplicationJobId() {
            return this.replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Instant getNextReplicationRunStartTime() {
            return this.nextReplicationRunStartTime;
        }

        @Override
        public final Builder nextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
            return this;
        }

        public final void setNextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationJobRequest build() {
            return new UpdateReplicationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationJobRequest> {
        public Builder replicationJobId(String var1);

        public Builder frequency(Integer var1);

        public Builder nextReplicationRunStartTime(Instant var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder roleName(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

