/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.rpcv2;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.StructuredJsonFactory;
import software.amazon.awssdk.protocols.json.internal.unmarshall.DefaultProtocolUnmarshallDependencies;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerRegistry;
import software.amazon.awssdk.protocols.json.internal.unmarshall.ProtocolUnmarshallDependencies;
import software.amazon.awssdk.protocols.rpcv2.internal.SdkRpcV2CborUnmarshaller;
import software.amazon.awssdk.protocols.rpcv2.internal.SdkRpcV2CborValueNodeFactory;
import software.amazon.awssdk.protocols.rpcv2.internal.SdkStructuredRpcV2CborFactory;
import software.amazon.awssdk.utils.Lazy;

@SdkProtectedApi
public final class SmithyRpcV2CborProtocolFactory
extends BaseAwsJsonProtocolFactory {
    private static final Lazy<ProtocolUnmarshallDependencies> DEPENDENCIES = new Lazy(SmithyRpcV2CborProtocolFactory::newProtocolUnmarshallDependencies);
    private static final JsonContentTypeResolver RPC_V2_CBOR = protocolMetadata -> "application/cbor";

    private SmithyRpcV2CborProtocolFactory(Builder builder) {
        super((BaseAwsJsonProtocolFactory.Builder)builder);
    }

    protected JsonContentTypeResolver getContentTypeResolver() {
        return RPC_V2_CBOR;
    }

    protected StructuredJsonFactory getSdkFactory() {
        return SdkStructuredRpcV2CborFactory.SDK_CBOR_FACTORY;
    }

    protected Map<MarshallLocation, TimestampFormatTrait.Format> getDefaultTimestampFormats() {
        return LazyHolder.DEFAULT_TIMESTAMP_FORMATS;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProtocolUnmarshallDependencies defaultProtocolUnmarshallDependencies() {
        return (ProtocolUnmarshallDependencies)DEPENDENCIES.getValue();
    }

    public static DefaultProtocolUnmarshallDependencies newProtocolUnmarshallDependencies() {
        return DefaultProtocolUnmarshallDependencies.builder().jsonUnmarshallerRegistry(SmithyRpcV2CborProtocolFactory.defaultCborUnmarshallerRegistry()).nodeValueFactory(SdkRpcV2CborValueNodeFactory.INSTANCE).timestampFormats(SmithyRpcV2CborProtocolFactory.defaultFormats()).jsonFactory(SdkStructuredRpcV2CborFactory.SDK_CBOR_FACTORY.getJsonFactory()).build();
    }

    private static Map<MarshallLocation, TimestampFormatTrait.Format> defaultFormats() {
        return LazyHolder.DEFAULT_TIMESTAMP_FORMATS;
    }

    private static JsonUnmarshallerRegistry defaultCborUnmarshallerRegistry() {
        return SdkRpcV2CborUnmarshaller.timestampFormatRegistryFactory(SmithyRpcV2CborProtocolFactory.defaultFormats());
    }

    private static class LazyHolder {
        private static final Map<MarshallLocation, TimestampFormatTrait.Format> DEFAULT_TIMESTAMP_FORMATS = LazyHolder.createDefaultTimestampFormats();

        private LazyHolder() {
        }

        static Map<MarshallLocation, TimestampFormatTrait.Format> createDefaultTimestampFormats() {
            EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
            formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.UNIX_TIMESTAMP);
            return Collections.unmodifiableMap(formats);
        }
    }

    public static final class Builder
    extends BaseAwsJsonProtocolFactory.Builder<Builder> {
        private Builder() {
            this.protocolUnmarshallDependencies(SmithyRpcV2CborProtocolFactory::defaultProtocolUnmarshallDependencies);
        }

        public SmithyRpcV2CborProtocolFactory build() {
            return new SmithyRpcV2CborProtocolFactory(this);
        }
    }
}

