/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverClient;
import software.amazon.awssdk.services.simspaceweaver.internal.UserAgentUtils;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse;

public class ListAppsIterable
implements SdkIterable<ListAppsResponse> {
    private final SimSpaceWeaverClient client;
    private final ListAppsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppsIterable(SimSpaceWeaverClient client, ListAppsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppsResponseFetcher();
    }

    public Iterator<ListAppsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppsResponseFetcher
    implements SyncPageFetcher<ListAppsResponse> {
        private ListAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppsResponse nextPage(ListAppsResponse previousPage) {
            if (previousPage == null) {
                return ListAppsIterable.this.client.listApps(ListAppsIterable.this.firstRequest);
            }
            return ListAppsIterable.this.client.listApps((ListAppsRequest)((Object)ListAppsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

