/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.simspaceweaver.model.LiveSimulationState;
import software.amazon.awssdk.services.simspaceweaver.model.LoggingConfiguration;
import software.amazon.awssdk.services.simspaceweaver.model.S3Location;
import software.amazon.awssdk.services.simspaceweaver.model.SimSpaceWeaverResponse;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationStatus;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSimulationResponse
extends SimSpaceWeaverResponse
implements ToCopyableBuilder<Builder, DescribeSimulationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::arn)).setter(DescribeSimulationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::creationTime)).setter(DescribeSimulationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::description)).setter(DescribeSimulationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::executionId)).setter(DescribeSimulationResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<LiveSimulationState> LIVE_SIMULATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LiveSimulationState").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::liveSimulationState)).setter(DescribeSimulationResponse.setter(Builder::liveSimulationState)).constructor(LiveSimulationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSimulationState").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::loggingConfiguration)).setter(DescribeSimulationResponse.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<String> MAXIMUM_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumDuration").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::maximumDuration)).setter(DescribeSimulationResponse.setter(Builder::maximumDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumDuration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::name)).setter(DescribeSimulationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::roleArn)).setter(DescribeSimulationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> SCHEMA_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaError").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::schemaError)).setter(DescribeSimulationResponse.setter(Builder::schemaError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaError").build()}).build();
    private static final SdkField<S3Location> SCHEMA_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaS3Location").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::schemaS3Location)).setter(DescribeSimulationResponse.setter(Builder::schemaS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaS3Location").build()}).build();
    private static final SdkField<S3Location> SNAPSHOT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotS3Location").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::snapshotS3Location)).setter(DescribeSimulationResponse.setter(Builder::snapshotS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotS3Location").build()}).build();
    private static final SdkField<String> START_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartError").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::startError)).setter(DescribeSimulationResponse.setter(Builder::startError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartError").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::statusAsString)).setter(DescribeSimulationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetStatus").getter(DescribeSimulationResponse.getter(DescribeSimulationResponse::targetStatusAsString)).setter(DescribeSimulationResponse.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, EXECUTION_ID_FIELD, LIVE_SIMULATION_STATE_FIELD, LOGGING_CONFIGURATION_FIELD, MAXIMUM_DURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SCHEMA_ERROR_FIELD, SCHEMA_S3_LOCATION_FIELD, SNAPSHOT_S3_LOCATION_FIELD, START_ERROR_FIELD, STATUS_FIELD, TARGET_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ExecutionId", EXECUTION_ID_FIELD);
            this.put("LiveSimulationState", LIVE_SIMULATION_STATE_FIELD);
            this.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
            this.put("MaximumDuration", MAXIMUM_DURATION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("SchemaError", SCHEMA_ERROR_FIELD);
            this.put("SchemaS3Location", SCHEMA_S3_LOCATION_FIELD);
            this.put("SnapshotS3Location", SNAPSHOT_S3_LOCATION_FIELD);
            this.put("StartError", START_ERROR_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("TargetStatus", TARGET_STATUS_FIELD);
        }
    });
    private final String arn;
    private final Instant creationTime;
    private final String description;
    private final String executionId;
    private final LiveSimulationState liveSimulationState;
    private final LoggingConfiguration loggingConfiguration;
    private final String maximumDuration;
    private final String name;
    private final String roleArn;
    private final String schemaError;
    private final S3Location schemaS3Location;
    private final S3Location snapshotS3Location;
    private final String startError;
    private final String status;
    private final String targetStatus;

    private DescribeSimulationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.executionId = builder.executionId;
        this.liveSimulationState = builder.liveSimulationState;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.maximumDuration = builder.maximumDuration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.schemaError = builder.schemaError;
        this.schemaS3Location = builder.schemaS3Location;
        this.snapshotS3Location = builder.snapshotS3Location;
        this.startError = builder.startError;
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final LiveSimulationState liveSimulationState() {
        return this.liveSimulationState;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final String maximumDuration() {
        return this.maximumDuration;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Deprecated
    public final String schemaError() {
        return this.schemaError;
    }

    public final S3Location schemaS3Location() {
        return this.schemaS3Location;
    }

    public final S3Location snapshotS3Location() {
        return this.snapshotS3Location;
    }

    public final String startError() {
        return this.startError;
    }

    public final SimulationStatus status() {
        return SimulationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SimulationTargetStatus targetStatus() {
        return SimulationTargetStatus.fromValue(this.targetStatus);
    }

    public final String targetStatusAsString() {
        return this.targetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.liveSimulationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaError());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.startError());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSimulationResponse)) {
            return false;
        }
        DescribeSimulationResponse other = (DescribeSimulationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.liveSimulationState(), other.liveSimulationState()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.maximumDuration(), other.maximumDuration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.schemaError(), other.schemaError()) && Objects.equals(this.schemaS3Location(), other.schemaS3Location()) && Objects.equals(this.snapshotS3Location(), other.snapshotS3Location()) && Objects.equals(this.startError(), other.startError()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSimulationResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("ExecutionId", (Object)this.executionId()).add("LiveSimulationState", (Object)this.liveSimulationState()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("MaximumDuration", (Object)this.maximumDuration()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("SchemaError", (Object)this.schemaError()).add("SchemaS3Location", (Object)this.schemaS3Location()).add("SnapshotS3Location", (Object)this.snapshotS3Location()).add("StartError", (Object)this.startError()).add("Status", (Object)this.statusAsString()).add("TargetStatus", (Object)this.targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "LiveSimulationState": {
                return Optional.ofNullable(clazz.cast(this.liveSimulationState()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "MaximumDuration": {
                return Optional.ofNullable(clazz.cast(this.maximumDuration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SchemaError": {
                return Optional.ofNullable(clazz.cast(this.schemaError()));
            }
            case "SchemaS3Location": {
                return Optional.ofNullable(clazz.cast(this.schemaS3Location()));
            }
            case "SnapshotS3Location": {
                return Optional.ofNullable(clazz.cast(this.snapshotS3Location()));
            }
            case "StartError": {
                return Optional.ofNullable(clazz.cast(this.startError()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSimulationResponse, T> g) {
        return obj -> g.apply((DescribeSimulationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SimSpaceWeaverResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String description;
        private String executionId;
        private LiveSimulationState liveSimulationState;
        private LoggingConfiguration loggingConfiguration;
        private String maximumDuration;
        private String name;
        private String roleArn;
        private String schemaError;
        private S3Location schemaS3Location;
        private S3Location snapshotS3Location;
        private String startError;
        private String status;
        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSimulationResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.executionId(model.executionId);
            this.liveSimulationState(model.liveSimulationState);
            this.loggingConfiguration(model.loggingConfiguration);
            this.maximumDuration(model.maximumDuration);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.schemaError(model.schemaError);
            this.schemaS3Location(model.schemaS3Location);
            this.snapshotS3Location(model.snapshotS3Location);
            this.startError(model.startError);
            this.status(model.status);
            this.targetStatus(model.targetStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final LiveSimulationState.Builder getLiveSimulationState() {
            return this.liveSimulationState != null ? this.liveSimulationState.toBuilder() : null;
        }

        public final void setLiveSimulationState(LiveSimulationState.BuilderImpl liveSimulationState) {
            this.liveSimulationState = liveSimulationState != null ? liveSimulationState.build() : null;
        }

        @Override
        public final Builder liveSimulationState(LiveSimulationState liveSimulationState) {
            this.liveSimulationState = liveSimulationState;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final String getMaximumDuration() {
            return this.maximumDuration;
        }

        public final void setMaximumDuration(String maximumDuration) {
            this.maximumDuration = maximumDuration;
        }

        @Override
        public final Builder maximumDuration(String maximumDuration) {
            this.maximumDuration = maximumDuration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Deprecated
        public final String getSchemaError() {
            return this.schemaError;
        }

        @Deprecated
        public final void setSchemaError(String schemaError) {
            this.schemaError = schemaError;
        }

        @Override
        @Deprecated
        public final Builder schemaError(String schemaError) {
            this.schemaError = schemaError;
            return this;
        }

        public final S3Location.Builder getSchemaS3Location() {
            return this.schemaS3Location != null ? this.schemaS3Location.toBuilder() : null;
        }

        public final void setSchemaS3Location(S3Location.BuilderImpl schemaS3Location) {
            this.schemaS3Location = schemaS3Location != null ? schemaS3Location.build() : null;
        }

        @Override
        public final Builder schemaS3Location(S3Location schemaS3Location) {
            this.schemaS3Location = schemaS3Location;
            return this;
        }

        public final S3Location.Builder getSnapshotS3Location() {
            return this.snapshotS3Location != null ? this.snapshotS3Location.toBuilder() : null;
        }

        public final void setSnapshotS3Location(S3Location.BuilderImpl snapshotS3Location) {
            this.snapshotS3Location = snapshotS3Location != null ? snapshotS3Location.build() : null;
        }

        @Override
        public final Builder snapshotS3Location(S3Location snapshotS3Location) {
            this.snapshotS3Location = snapshotS3Location;
            return this;
        }

        public final String getStartError() {
            return this.startError;
        }

        public final void setStartError(String startError) {
            this.startError = startError;
        }

        @Override
        public final Builder startError(String startError) {
            this.startError = startError;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(SimulationTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public DescribeSimulationResponse build() {
            return new DescribeSimulationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SimSpaceWeaverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSimulationResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder executionId(String var1);

        public Builder liveSimulationState(LiveSimulationState var1);

        default public Builder liveSimulationState(Consumer<LiveSimulationState.Builder> liveSimulationState) {
            return this.liveSimulationState((LiveSimulationState)((LiveSimulationState.Builder)LiveSimulationState.builder().applyMutation(liveSimulationState)).build());
        }

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder maximumDuration(String var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        @Deprecated
        public Builder schemaError(String var1);

        public Builder schemaS3Location(S3Location var1);

        default public Builder schemaS3Location(Consumer<S3Location.Builder> schemaS3Location) {
            return this.schemaS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(schemaS3Location)).build());
        }

        public Builder snapshotS3Location(S3Location var1);

        default public Builder snapshotS3Location(Consumer<S3Location.Builder> snapshotS3Location) {
            return this.snapshotS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(snapshotS3Location)).build());
        }

        public Builder startError(String var1);

        public Builder status(String var1);

        public Builder status(SimulationStatus var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(SimulationTargetStatus var1);
    }
}

