/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.ProtectedResourceType;
import software.amazon.awssdk.services.shield.model.ProtectedResourceTypeFiltersCopier;
import software.amazon.awssdk.services.shield.model.ProtectionNameFiltersCopier;
import software.amazon.awssdk.services.shield.model.ResourceArnFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InclusionProtectionFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InclusionProtectionFilters> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceArns").getter(InclusionProtectionFilters.getter(InclusionProtectionFilters::resourceArns)).setter(InclusionProtectionFilters.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROTECTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectionNames").getter(InclusionProtectionFilters.getter(InclusionProtectionFilters::protectionNames)).setter(InclusionProtectionFilters.setter(Builder::protectionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(InclusionProtectionFilters.getter(InclusionProtectionFilters::resourceTypesAsStrings)).setter(InclusionProtectionFilters.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD, PROTECTION_NAMES_FIELD, RESOURCE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> resourceArns;
    private final List<String> protectionNames;
    private final List<String> resourceTypes;

    private InclusionProtectionFilters(BuilderImpl builder) {
        this.resourceArns = builder.resourceArns;
        this.protectionNames = builder.protectionNames;
        this.resourceTypes = builder.resourceTypes;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final boolean hasProtectionNames() {
        return this.protectionNames != null && !(this.protectionNames instanceof SdkAutoConstructList);
    }

    public final List<String> protectionNames() {
        return this.protectionNames;
    }

    public final List<ProtectedResourceType> resourceTypes() {
        return ProtectedResourceTypeFiltersCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectionNames() ? this.protectionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InclusionProtectionFilters)) {
            return false;
        }
        InclusionProtectionFilters other = (InclusionProtectionFilters)obj;
        return this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && this.hasProtectionNames() == other.hasProtectionNames() && Objects.equals(this.protectionNames(), other.protectionNames()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InclusionProtectionFilters").add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("ProtectionNames", this.hasProtectionNames() ? this.protectionNames() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "ProtectionNames": {
                return Optional.ofNullable(clazz.cast(this.protectionNames()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InclusionProtectionFilters, T> g) {
        return obj -> g.apply((InclusionProtectionFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> protectionNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InclusionProtectionFilters model) {
            this.resourceArns(model.resourceArns);
            this.protectionNames(model.protectionNames);
            this.resourceTypesWithStrings(model.resourceTypes);
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFiltersCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnFiltersCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getProtectionNames() {
            if (this.protectionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protectionNames;
        }

        public final void setProtectionNames(Collection<String> protectionNames) {
            this.protectionNames = ProtectionNameFiltersCopier.copy(protectionNames);
        }

        @Override
        public final Builder protectionNames(Collection<String> protectionNames) {
            this.protectionNames = ProtectionNameFiltersCopier.copy(protectionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectionNames(String ... protectionNames) {
            this.protectionNames(Arrays.asList(protectionNames));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ProtectedResourceType> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ProtectedResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public InclusionProtectionFilters build() {
            return new InclusionProtectionFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InclusionProtectionFilters> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder protectionNames(Collection<String> var1);

        public Builder protectionNames(String ... var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ProtectedResourceType> var1);

        public Builder resourceTypes(ProtectedResourceType ... var1);
    }
}

