/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The automatic application layer DDoS mitigation settings for a <a>Protection</a>. This configuration determines
 * whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events
 * that Shield Advanced determines to be DDoS attacks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationLayerAutomaticResponseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationLayerAutomaticResponseConfiguration.Builder, ApplicationLayerAutomaticResponseConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ApplicationLayerAutomaticResponseConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ResponseAction> ACTION_FIELD = SdkField.<ResponseAction> builder(MarshallingType.SDK_POJO)
            .memberName("Action").getter(getter(ApplicationLayerAutomaticResponseConfiguration::action))
            .setter(setter(Builder::action)).constructor(ResponseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final ResponseAction action;

    private ApplicationLayerAutomaticResponseConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.action = builder.action;
    }

    /**
     * <p>
     * Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationLayerAutomaticResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
     * @see ApplicationLayerAutomaticResponseStatus
     */
    public final ApplicationLayerAutomaticResponseStatus status() {
        return ApplicationLayerAutomaticResponseStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationLayerAutomaticResponseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
     * @see ApplicationLayerAutomaticResponseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the
     * protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic
     * application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced
     * creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with
     * the resource.
     * </p>
     * 
     * @return Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf
     *         of the protected resource in response to DDoS attacks. You specify this as part of the configuration for
     *         the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation.
     *         Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that
     *         you have associated with the resource.
     */
    public final ResponseAction action() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationLayerAutomaticResponseConfiguration)) {
            return false;
        }
        ApplicationLayerAutomaticResponseConfiguration other = (ApplicationLayerAutomaticResponseConfiguration) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(action(), other.action());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationLayerAutomaticResponseConfiguration").add("Status", statusAsString())
                .add("Action", action()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationLayerAutomaticResponseConfiguration, T> g) {
        return obj -> g.apply((ApplicationLayerAutomaticResponseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationLayerAutomaticResponseConfiguration> {
        /**
         * <p>
         * Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
         * </p>
         * 
         * @param status
         *        Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
         * @see ApplicationLayerAutomaticResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationLayerAutomaticResponseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
         * </p>
         * 
         * @param status
         *        Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
         * @see ApplicationLayerAutomaticResponseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationLayerAutomaticResponseStatus
         */
        Builder status(ApplicationLayerAutomaticResponseStatus status);

        /**
         * <p>
         * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of
         * the protected resource in response to DDoS attacks. You specify this as part of the configuration for the
         * automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield
         * Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have
         * associated with the resource.
         * </p>
         * 
         * @param action
         *        Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on
         *        behalf of the protected resource in response to DDoS attacks. You specify this as part of the
         *        configuration for the automatic application layer DDoS mitigation feature, when you enable or update
         *        automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group,
         *        inside the web ACL that you have associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ResponseAction action);

        /**
         * <p>
         * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of
         * the protected resource in response to DDoS attacks. You specify this as part of the configuration for the
         * automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield
         * Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have
         * associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseAction.Builder} avoiding the need
         * to create one manually via {@link ResponseAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ResponseAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ResponseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ResponseAction)
         */
        default Builder action(Consumer<ResponseAction.Builder> action) {
            return action(ResponseAction.builder().applyMutation(action).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private ResponseAction action;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationLayerAutomaticResponseConfiguration model) {
            status(model.status);
            action(model.action);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationLayerAutomaticResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ResponseAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(ResponseAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ResponseAction action) {
            this.action = action;
            return this;
        }

        @Override
        public ApplicationLayerAutomaticResponseConfiguration build() {
            return new ApplicationLayerAutomaticResponseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
