/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRange implements SdkPojo, Serializable, ToCopyableBuilder<TimeRange.Builder, TimeRange> {
    private static final SdkField<Instant> FROM_INCLUSIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FromInclusive").getter(getter(TimeRange::fromInclusive)).setter(setter(Builder::fromInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromInclusive").build()).build();

    private static final SdkField<Instant> TO_EXCLUSIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ToExclusive").getter(getter(TimeRange::toExclusive)).setter(setter(Builder::toExclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToExclusive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_INCLUSIVE_FIELD,
            TO_EXCLUSIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant fromInclusive;

    private final Instant toExclusive;

    private TimeRange(BuilderImpl builder) {
        this.fromInclusive = builder.fromInclusive;
        this.toExclusive = builder.toExclusive;
    }

    /**
     * <p>
     * The start time, in Unix time in seconds. For more information see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
     * </p>
     * 
     * @return The start time, in Unix time in seconds. For more information see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
     *         >timestamp</a>.
     */
    public final Instant fromInclusive() {
        return fromInclusive;
    }

    /**
     * <p>
     * The end time, in Unix time in seconds. For more information see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
     * </p>
     * 
     * @return The end time, in Unix time in seconds. For more information see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
     *         >timestamp</a>.
     */
    public final Instant toExclusive() {
        return toExclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(toExclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange) obj;
        return Objects.equals(fromInclusive(), other.fromInclusive()) && Objects.equals(toExclusive(), other.toExclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeRange").add("FromInclusive", fromInclusive()).add("ToExclusive", toExclusive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromInclusive":
            return Optional.ofNullable(clazz.cast(fromInclusive()));
        case "ToExclusive":
            return Optional.ofNullable(clazz.cast(toExclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeRange, T> g) {
        return obj -> g.apply((TimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRange> {
        /**
         * <p>
         * The start time, in Unix time in seconds. For more information see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
         * </p>
         * 
         * @param fromInclusive
         *        The start time, in Unix time in seconds. For more information see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
         *        >timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromInclusive(Instant fromInclusive);

        /**
         * <p>
         * The end time, in Unix time in seconds. For more information see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp</a>.
         * </p>
         * 
         * @param toExclusive
         *        The end time, in Unix time in seconds. For more information see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types"
         *        >timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toExclusive(Instant toExclusive);
    }

    static final class BuilderImpl implements Builder {
        private Instant fromInclusive;

        private Instant toExclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            fromInclusive(model.fromInclusive);
            toExclusive(model.toExclusive);
        }

        public final Instant getFromInclusive() {
            return fromInclusive;
        }

        @Override
        public final Builder fromInclusive(Instant fromInclusive) {
            this.fromInclusive = fromInclusive;
            return this;
        }

        public final void setFromInclusive(Instant fromInclusive) {
            this.fromInclusive = fromInclusive;
        }

        public final Instant getToExclusive() {
            return toExclusive;
        }

        @Override
        public final Builder toExclusive(Instant toExclusive) {
            this.toExclusive = toExclusive;
            return this;
        }

        public final void setToExclusive(Instant toExclusive) {
            this.toExclusive = toExclusive;
        }

        @Override
        public TimeRange build() {
            return new TimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
