/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.ProtectedResourceType;
import software.amazon.awssdk.services.shield.model.ProtectionGroupAggregation;
import software.amazon.awssdk.services.shield.model.ProtectionGroupMembersCopier;
import software.amazon.awssdk.services.shield.model.ProtectionGroupPattern;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectionGroup> {
    private static final SdkField<String> PROTECTION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectionGroupId").getter(ProtectionGroup.getter(ProtectionGroup::protectionGroupId)).setter(ProtectionGroup.setter(Builder::protectionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroupId").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(ProtectionGroup.getter(ProtectionGroup::aggregationAsString)).setter(ProtectionGroup.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pattern").getter(ProtectionGroup.getter(ProtectionGroup::patternAsString)).setter(ProtectionGroup.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ProtectionGroup.getter(ProtectionGroup::resourceTypeAsString)).setter(ProtectionGroup.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(ProtectionGroup.getter(ProtectionGroup::members)).setter(ProtectionGroup.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUP_ID_FIELD, AGGREGATION_FIELD, PATTERN_FIELD, RESOURCE_TYPE_FIELD, MEMBERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String protectionGroupId;
    private final String aggregation;
    private final String pattern;
    private final String resourceType;
    private final List<String> members;

    private ProtectionGroup(BuilderImpl builder) {
        this.protectionGroupId = builder.protectionGroupId;
        this.aggregation = builder.aggregation;
        this.pattern = builder.pattern;
        this.resourceType = builder.resourceType;
        this.members = builder.members;
    }

    public final String protectionGroupId() {
        return this.protectionGroupId;
    }

    public final ProtectionGroupAggregation aggregation() {
        return ProtectionGroupAggregation.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final ProtectionGroupPattern pattern() {
        return ProtectionGroupPattern.fromValue(this.pattern);
    }

    public final String patternAsString() {
        return this.pattern;
    }

    public final ProtectedResourceType resourceType() {
        return ProtectedResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<String> members() {
        return this.members;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectionGroup)) {
            return false;
        }
        ProtectionGroup other = (ProtectionGroup)obj;
        return Objects.equals(this.protectionGroupId(), other.protectionGroupId()) && Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && Objects.equals(this.patternAsString(), other.patternAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectionGroup").add("ProtectionGroupId", (Object)this.protectionGroupId()).add("Aggregation", (Object)this.aggregationAsString()).add("Pattern", (Object)this.patternAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Members", this.hasMembers() ? this.members() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionGroupId": {
                return Optional.ofNullable(clazz.cast(this.protectionGroupId()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "Pattern": {
                return Optional.ofNullable(clazz.cast(this.patternAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectionGroup, T> g) {
        return obj -> g.apply((ProtectionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protectionGroupId;
        private String aggregation;
        private String pattern;
        private String resourceType;
        private List<String> members = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectionGroup model) {
            this.protectionGroupId(model.protectionGroupId);
            this.aggregation(model.aggregation);
            this.pattern(model.pattern);
            this.resourceType(model.resourceType);
            this.members(model.members);
        }

        public final String getProtectionGroupId() {
            return this.protectionGroupId;
        }

        @Override
        public final Builder protectionGroupId(String protectionGroupId) {
            this.protectionGroupId = protectionGroupId;
            return this;
        }

        public final void setProtectionGroupId(String protectionGroupId) {
            this.protectionGroupId = protectionGroupId;
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(ProtectionGroupAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        public final String getPattern() {
            return this.pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        public final Builder pattern(ProtectionGroupPattern pattern) {
            this.pattern(pattern == null ? null : pattern.toString());
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ProtectedResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getMembers() {
            if (this.members instanceof SdkAutoConstructList) {
                return null;
            }
            return this.members;
        }

        @Override
        public final Builder members(Collection<String> members) {
            this.members = ProtectionGroupMembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(String ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        public final void setMembers(Collection<String> members) {
            this.members = ProtectionGroupMembersCopier.copy(members);
        }

        public ProtectionGroup build() {
            return new ProtectionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectionGroup> {
        public Builder protectionGroupId(String var1);

        public Builder aggregation(String var1);

        public Builder aggregation(ProtectionGroupAggregation var1);

        public Builder pattern(String var1);

        public Builder pattern(ProtectionGroupPattern var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ProtectedResourceType var1);

        public Builder members(Collection<String> var1);

        public Builder members(String ... var1);
    }
}

