/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.shield.model.AccessDeniedException;
import software.amazon.awssdk.services.shield.model.AccessDeniedForDependencyException;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.AssociateHealthCheckRequest;
import software.amazon.awssdk.services.shield.model.AssociateHealthCheckResponse;
import software.amazon.awssdk.services.shield.model.CreateProtectionRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionResponse;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackResponse;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessRequest;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessResponse;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.DisassociateHealthCheckRequest;
import software.amazon.awssdk.services.shield.model.DisassociateHealthCheckResponse;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateRequest;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateResponse;
import software.amazon.awssdk.services.shield.model.InternalErrorException;
import software.amazon.awssdk.services.shield.model.InvalidOperationException;
import software.amazon.awssdk.services.shield.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.shield.model.InvalidParameterException;
import software.amazon.awssdk.services.shield.model.InvalidResourceException;
import software.amazon.awssdk.services.shield.model.LimitsExceededException;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.LockedSubscriptionException;
import software.amazon.awssdk.services.shield.model.NoAssociatedRoleException;
import software.amazon.awssdk.services.shield.model.OptimisticLockException;
import software.amazon.awssdk.services.shield.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.shield.model.ResourceNotFoundException;
import software.amazon.awssdk.services.shield.model.ShieldException;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionResponse;

/**
 * Service client for accessing AWS Shield. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Shield Advanced</fullname>
 * <p>
 * This is the <i>AWS Shield Advanced API Reference</i>. This guide is for developers who need detailed information
 * about the AWS Shield Advanced API actions, data types, and errors. For detailed information about AWS WAF and AWS
 * Shield Advanced features and an overview of how to use the AWS WAF and AWS Shield Advanced APIs, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ShieldClient extends SdkClient {
    String SERVICE_NAME = "shield";

    /**
     * Create a {@link ShieldClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ShieldClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ShieldClient}.
     */
    static ShieldClientBuilder builder() {
        return new DefaultShieldClientBuilder();
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT) to access the specified Amazon S3 bucket containing your AWS WAF logs.
     * You can associate up to 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtLogBucketRequest
     * @return Result of the AssociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specifed does not exist.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the DDoS Response Team, the user submitting the request must
     *         have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateDrtLogBucketResponse associateDRTLogBucket(AssociateDrtLogBucketRequest associateDrtLogBucketRequest)
            throws InternalErrorException, InvalidOperationException, NoAssociatedRoleException, LimitsExceededException,
            InvalidParameterException, AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT) to access the specified Amazon S3 bucket containing your AWS WAF logs.
     * You can associate up to 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtLogBucketRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param associateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specifed does not exist.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the DDoS Response Team, the user submitting the request must
     *         have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateDrtLogBucketResponse associateDRTLogBucket(
            Consumer<AssociateDrtLogBucketRequest.Builder> associateDrtLogBucketRequest) throws InternalErrorException,
            InvalidOperationException, NoAssociatedRoleException, LimitsExceededException, InvalidParameterException,
            AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return associateDRTLogBucket(AssociateDrtLogBucketRequest.builder().applyMutation(associateDrtLogBucketRequest).build());
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT), using the specified role, to access your AWS account to assist with DDoS
     * attack mitigation during potential attacks. This enables the DRT to inspect your AWS WAF configuration and create
     * or update AWS WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information
     * see <a
     * href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and
     * Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>
     * . For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * Policy Elements: Principal</a>.
     * </p>
     * <p>
     * The DRT will have access only to your AWS WAF and Shield resources. By submitting this request, you authorize the
     * DRT to inspect your AWS WAF and Shield configuration and create and update AWS WAF rules and web ACLs on your
     * behalf. The DRT takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * User Permissions to Pass a Role to an AWS Service</a>.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtRoleRequest
     * @return Result of the AssociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the DDoS Response Team, the user submitting the request must
     *         have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDrtRoleResponse associateDRTRole(AssociateDrtRoleRequest associateDrtRoleRequest)
            throws InternalErrorException, InvalidOperationException, InvalidParameterException,
            AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT), using the specified role, to access your AWS account to assist with DDoS
     * attack mitigation during potential attacks. This enables the DRT to inspect your AWS WAF configuration and create
     * or update AWS WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information
     * see <a
     * href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and
     * Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>
     * . For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * Policy Elements: Principal</a>.
     * </p>
     * <p>
     * The DRT will have access only to your AWS WAF and Shield resources. By submitting this request, you authorize the
     * DRT to inspect your AWS WAF and Shield configuration and create and update AWS WAF rules and web ACLs on your
     * behalf. The DRT takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * User Permissions to Pass a Role to an AWS Service</a>.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtRoleRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param associateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTRoleRequest.Builder} to create a request.
     * @return Result of the AssociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the DDoS Response Team, the user submitting the request must
     *         have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDrtRoleResponse associateDRTRole(Consumer<AssociateDrtRoleRequest.Builder> associateDrtRoleRequest)
            throws InternalErrorException, InvalidOperationException, InvalidParameterException,
            AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return associateDRTRole(AssociateDrtRoleRequest.builder().applyMutation(associateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     *
     * @param associateHealthCheckRequest
     * @return Result of the AssociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateHealthCheckResponse associateHealthCheck(AssociateHealthCheckRequest associateHealthCheckRequest)
            throws InternalErrorException, LimitsExceededException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateHealthCheckRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateHealthCheckRequest#builder()}
     * </p>
     *
     * @param associateHealthCheckRequest
     *        A {@link Consumer} that will call methods on {@link AssociateHealthCheckRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateHealthCheckResponse associateHealthCheck(
            Consumer<AssociateHealthCheckRequest.Builder> associateHealthCheckRequest) throws InternalErrorException,
            LimitsExceededException, ResourceNotFoundException, InvalidParameterException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        return associateHealthCheck(AssociateHealthCheckRequest.builder().applyMutation(associateHealthCheckRequest).build());
    }

    /**
     * <p>
     * Enables AWS Shield Advanced for a specific AWS resource. The resource can be an Amazon CloudFront distribution,
     * Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
     * 53 hosted zone.
     * </p>
     * <p>
     * You can add protection to only a single resource with each CreateProtection request. If you want to add
     * protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">AWS WAF
     * console</a>. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with AWS
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add AWS Shield
     * Advanced Protection to more AWS Resources</a>.
     * </p>
     *
     * @param createProtectionRequest
     * @return Result of the CreateProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProtectionResponse createProtection(CreateProtectionRequest createProtectionRequest)
            throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException,
            ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables AWS Shield Advanced for a specific AWS resource. The resource can be an Amazon CloudFront distribution,
     * Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
     * 53 hosted zone.
     * </p>
     * <p>
     * You can add protection to only a single resource with each CreateProtection request. If you want to add
     * protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">AWS WAF
     * console</a>. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with AWS
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add AWS Shield
     * Advanced Protection to more AWS Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateProtectionRequest#builder()}
     * </p>
     *
     * @param createProtectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProtectionRequest.Builder} to create a request.
     * @return Result of the CreateProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProtectionResponse createProtection(Consumer<CreateProtectionRequest.Builder> createProtectionRequest)
            throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException,
            ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return createProtection(CreateProtectionRequest.builder().applyMutation(createProtectionRequest).build());
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * As part of this request you can specify <code>EmergencySettings</code> that automaticaly grant the DDoS response
     * team (DRT) needed permissions to assist you during a suspected DDoS attack. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/authorize-DRT.html">Authorize the DDoS Response Team
     * to Create Rules and Web ACLs on Your Behalf</a>.
     * </p>
     * <p>
     * To use the services of the DRT, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateSubscription
     * @see #createSubscription(CreateSubscriptionRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubscriptionResponse createSubscription() throws InternalErrorException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, ShieldException {
        return createSubscription(CreateSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * As part of this request you can specify <code>EmergencySettings</code> that automaticaly grant the DDoS response
     * team (DRT) needed permissions to assist you during a suspected DDoS attack. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/authorize-DRT.html">Authorize the DDoS Response Team
     * to Create Rules and Web ACLs on Your Behalf</a>.
     * </p>
     * <p>
     * To use the services of the DRT, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @param createSubscriptionRequest
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest createSubscriptionRequest)
            throws InternalErrorException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * As part of this request you can specify <code>EmergencySettings</code> that automaticaly grant the DDoS response
     * team (DRT) needed permissions to assist you during a suspected DDoS attack. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/authorize-DRT.html">Authorize the DDoS Response Team
     * to Create Rules and Web ACLs on Your Behalf</a>.
     * </p>
     * <p>
     * To use the services of the DRT, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubscriptionResponse createSubscription(Consumer<CreateSubscriptionRequest.Builder> createSubscriptionRequest)
            throws InternalErrorException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            ShieldException {
        return createSubscription(CreateSubscriptionRequest.builder().applyMutation(createSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Shield Advanced <a>Protection</a>.
     * </p>
     *
     * @param deleteProtectionRequest
     * @return Result of the DeleteProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DeleteProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProtectionResponse deleteProtection(DeleteProtectionRequest deleteProtectionRequest)
            throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Shield Advanced <a>Protection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProtectionRequest#builder()}
     * </p>
     *
     * @param deleteProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtectionRequest.Builder} to create a request.
     * @return Result of the DeleteProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DeleteProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProtectionResponse deleteProtection(Consumer<DeleteProtectionRequest.Builder> deleteProtectionRequest)
            throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, AwsServiceException,
            SdkClientException, ShieldException {
        return deleteProtection(DeleteProtectionRequest.builder().applyMutation(deleteProtectionRequest).build());
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     *
     * @param describeAttackRequest
     * @return Result of the DescribeAttack operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws AccessDeniedException
     *         Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not
     *         have the appropriate permissions to access the <code>AttackId</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeAttack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAttackResponse describeAttack(DescribeAttackRequest describeAttackRequest) throws InternalErrorException,
            AccessDeniedException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttackRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAttackRequest#builder()}
     * </p>
     *
     * @param describeAttackRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAttackRequest.Builder} to create a request.
     * @return Result of the DescribeAttack operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws AccessDeniedException
     *         Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not
     *         have the appropriate permissions to access the <code>AttackId</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeAttack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAttackResponse describeAttack(Consumer<DescribeAttackRequest.Builder> describeAttackRequest)
            throws InternalErrorException, AccessDeniedException, AwsServiceException, SdkClientException, ShieldException {
        return describeAttack(DescribeAttackRequest.builder().applyMutation(describeAttackRequest).build());
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the DDoS Response team (DRT) to access your
     * AWS account while assisting with attack mitigation.
     * </p>
     *
     * @param describeDrtAccessRequest
     * @return Result of the DescribeDRTAccess operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeDRTAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDrtAccessResponse describeDRTAccess(DescribeDrtAccessRequest describeDrtAccessRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the DDoS Response team (DRT) to access your
     * AWS account while assisting with attack mitigation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDrtAccessRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDrtAccessRequest#builder()}
     * </p>
     *
     * @param describeDrtAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDRTAccessRequest.Builder} to create a request.
     * @return Result of the DescribeDRTAccess operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeDRTAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDrtAccessResponse describeDRTAccess(Consumer<DescribeDrtAccessRequest.Builder> describeDrtAccessRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeDRTAccess(DescribeDrtAccessRequest.builder().applyMutation(describeDrtAccessRequest).build());
    }

    /**
     * <p>
     * Lists the email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     * @return Result of the DescribeEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEmergencyContactSettingsResponse describeEmergencyContactSettings(
            DescribeEmergencyContactSettingsRequest describeEmergencyContactSettingsRequest) throws InternalErrorException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEmergencyContactSettingsResponse describeEmergencyContactSettings(
            Consumer<DescribeEmergencyContactSettingsRequest.Builder> describeEmergencyContactSettingsRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest.builder()
                .applyMutation(describeEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     *
     * @param describeProtectionRequest
     * @return Result of the DescribeProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProtectionResponse describeProtection(DescribeProtectionRequest describeProtectionRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProtectionRequest#builder()}
     * </p>
     *
     * @param describeProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProtectionResponse describeProtection(Consumer<DescribeProtectionRequest.Builder> describeProtectionRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return describeProtection(DescribeProtectionRequest.builder().applyMutation(describeProtectionRequest).build());
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     *
     * @return Result of the DescribeSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeSubscription
     * @see #describeSubscription(DescribeSubscriptionRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubscriptionResponse describeSubscription() throws InternalErrorException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        return describeSubscription(DescribeSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     *
     * @param describeSubscriptionRequest
     * @return Result of the DescribeSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubscriptionResponse describeSubscription(DescribeSubscriptionRequest describeSubscriptionRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubscriptionRequest#builder()}
     * </p>
     *
     * @param describeSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubscriptionResponse describeSubscription(
            Consumer<DescribeSubscriptionRequest.Builder> describeSubscriptionRequest) throws InternalErrorException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeSubscription(DescribeSubscriptionRequest.builder().applyMutation(describeSubscriptionRequest).build());
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to the specified Amazon S3 bucket containing your AWS WAF logs.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     * @return Result of the DisassociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specifed does not exist.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the DDoS Response Team, the user submitting the request must
     *         have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDrtLogBucketResponse disassociateDRTLogBucket(
            DisassociateDrtLogBucketRequest disassociateDrtLogBucketRequest) throws InternalErrorException,
            InvalidOperationException, NoAssociatedRoleException, AccessDeniedForDependencyException, OptimisticLockException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to the specified Amazon S3 bucket containing your AWS WAF logs.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtLogBucketRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specifed does not exist.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the DDoS Response Team, the user submitting the request must
     *         have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDrtLogBucketResponse disassociateDRTLogBucket(
            Consumer<DisassociateDrtLogBucketRequest.Builder> disassociateDrtLogBucketRequest) throws InternalErrorException,
            InvalidOperationException, NoAssociatedRoleException, AccessDeniedForDependencyException, OptimisticLockException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return disassociateDRTLogBucket(DisassociateDrtLogBucketRequest.builder().applyMutation(disassociateDrtLogBucketRequest)
                .build());
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     *
     * @return Result of the DisassociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTRole
     * @see #disassociateDRTRole(DisassociateDrtRoleRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateDrtRoleResponse disassociateDRTRole() throws InternalErrorException, InvalidOperationException,
            OptimisticLockException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().build());
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     *
     * @param disassociateDrtRoleRequest
     * @return Result of the DisassociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateDrtRoleResponse disassociateDRTRole(DisassociateDrtRoleRequest disassociateDrtRoleRequest)
            throws InternalErrorException, InvalidOperationException, OptimisticLockException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtRoleRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param disassociateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTRoleRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateDrtRoleResponse disassociateDRTRole(
            Consumer<DisassociateDrtRoleRequest.Builder> disassociateDrtRoleRequest) throws InternalErrorException,
            InvalidOperationException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().applyMutation(disassociateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced
     * protection. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     *
     * @param disassociateHealthCheckRequest
     * @return Result of the DisassociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateHealthCheckResponse disassociateHealthCheck(DisassociateHealthCheckRequest disassociateHealthCheckRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your AWS resource to improve responsiveness and accuracy in attack detection and
     * mitigation.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced
     * protection. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateHealthCheckRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateHealthCheckRequest#builder()}
     * </p>
     *
     * @param disassociateHealthCheckRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateHealthCheckRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateHealthCheckResponse disassociateHealthCheck(
            Consumer<DisassociateHealthCheckRequest.Builder> disassociateHealthCheckRequest) throws InternalErrorException,
            InvalidParameterException, ResourceNotFoundException, OptimisticLockException, AwsServiceException,
            SdkClientException, ShieldException {
        return disassociateHealthCheck(DisassociateHealthCheckRequest.builder().applyMutation(disassociateHealthCheckRequest)
                .build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @return Result of the GetSubscriptionState operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.GetSubscriptionState
     * @see #getSubscriptionState(GetSubscriptionStateRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionStateResponse getSubscriptionState() throws InternalErrorException, AwsServiceException,
            SdkClientException, ShieldException {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @param getSubscriptionStateRequest
     * @return Result of the GetSubscriptionState operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.GetSubscriptionState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionStateResponse getSubscriptionState(GetSubscriptionStateRequest getSubscriptionStateRequest)
            throws InternalErrorException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionStateRequest#builder()}
     * </p>
     *
     * @param getSubscriptionStateRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionStateRequest.Builder} to create a
     *        request.
     * @return Result of the GetSubscriptionState operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.GetSubscriptionState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionStateResponse getSubscriptionState(
            Consumer<GetSubscriptionStateRequest.Builder> getSubscriptionStateRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, ShieldException {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().applyMutation(getSubscriptionStateRequest).build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @return Result of the ListAttacks operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see #listAttacks(ListAttacksRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksResponse listAttacks() throws InternalErrorException, InvalidParameterException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return listAttacks(ListAttacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @param listAttacksRequest
     * @return Result of the ListAttacks operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksResponse listAttacks(ListAttacksRequest listAttacksRequest) throws InternalErrorException,
            InvalidParameterException, InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttacksRequest#builder()}
     * </p>
     *
     * @param listAttacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAttacksRequest.Builder} to create a request.
     * @return Result of the ListAttacks operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksResponse listAttacks(Consumer<ListAttacksRequest.Builder> listAttacksRequest)
            throws InternalErrorException, InvalidParameterException, InvalidOperationException, AwsServiceException,
            SdkClientException, ShieldException {
        return listAttacks(ListAttacksRequest.builder().applyMutation(listAttacksRequest).build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     *
     * @return Result of the ListProtections operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the NextToken specified in the request is invalid. Submit the request using
     *         the NextToken value that was returned in the response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see #listProtections(ListProtectionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsResponse listProtections() throws InternalErrorException, ResourceNotFoundException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        return listProtections(ListProtectionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     *
     * @param listProtectionsRequest
     * @return Result of the ListProtections operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the NextToken specified in the request is invalid. Submit the request using
     *         the NextToken value that was returned in the response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsResponse listProtections(ListProtectionsRequest listProtectionsRequest) throws InternalErrorException,
            ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProtectionsRequest#builder()}
     * </p>
     *
     * @param listProtectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionsRequest.Builder} to create a request.
     * @return Result of the ListProtections operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the NextToken specified in the request is invalid. Submit the request using
     *         the NextToken value that was returned in the response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsResponse listProtections(Consumer<ListProtectionsRequest.Builder> listProtectionsRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return listProtections(ListProtectionsRequest.builder().applyMutation(listProtectionsRequest).build());
    }

    /**
     * <p>
     * Updates the details of the list of email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     * @return Result of the UpdateEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEmergencyContactSettingsResponse updateEmergencyContactSettings(
            UpdateEmergencyContactSettingsRequest updateEmergencyContactSettingsRequest) throws InternalErrorException,
            InvalidParameterException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of the list of email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEmergencyContactSettingsResponse updateEmergencyContactSettings(
            Consumer<UpdateEmergencyContactSettingsRequest.Builder> updateEmergencyContactSettingsRequest)
            throws InternalErrorException, InvalidParameterException, OptimisticLockException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        return updateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest.builder()
                .applyMutation(updateEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     *
     * @param updateSubscriptionRequest
     * @return Result of the UpdateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LockedSubscriptionException
     *         You are trying to update a subscription that has not yet completed the 1-year commitment. You can change
     *         the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception
     *         indicates that you are attempting to change <code>AutoRenew</code> prior to that period.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSubscriptionResponse updateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest)
            throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LockedSubscriptionException
     *         You are trying to update a subscription that has not yet completed the 1-year commitment. You can change
     *         the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception
     *         indicates that you are attempting to change <code>AutoRenew</code> prior to that period.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid.
     * @throws OptimisticLockException
     *         Exception that indicates that the protection state has been modified by another client. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSubscriptionResponse updateSubscription(Consumer<UpdateSubscriptionRequest.Builder> updateSubscriptionRequest)
            throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, AwsServiceException, SdkClientException, ShieldException {
        return updateSubscription(UpdateSubscriptionRequest.builder().applyMutation(updateSubscriptionRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("shield");
    }
}
