/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.Mitigation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MitigationMarshaller {
    private static final MarshallingInfo<String> MITIGATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MitigationName").isBinary(false).build();
    private static final MitigationMarshaller INSTANCE = new MitigationMarshaller();

    private MitigationMarshaller() {
    }

    public static MitigationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mitigation mitigation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mitigation, (String)"mitigation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mitigation.mitigationName(), MITIGATIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

