/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.transform.ProtectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Protection
implements StructuredPojo,
ToCopyableBuilder<Builder, Protection> {
    private final String id;
    private final String name;
    private final String resourceArn;

    private Protection(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.resourceArn = builder.resourceArn;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Protection)) {
            return false;
        }
        Protection other = (Protection)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public String toString() {
        return ToString.builder((String)"Protection").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProtectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Protection model) {
            this.id(model.id);
            this.name(model.name);
            this.resourceArn(model.resourceArn);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public Protection build() {
            return new Protection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Protection> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder resourceArn(String var1);
    }
}

