/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.shield.model.Protection;
import software.amazon.awssdk.services.shield.model.ProtectionsCopier;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProtectionsResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, ListProtectionsResponse> {
    private final List<Protection> protections;
    private final String nextToken;

    private ListProtectionsResponse(BuilderImpl builder) {
        super(builder);
        this.protections = builder.protections;
        this.nextToken = builder.nextToken;
    }

    public List<Protection> protections() {
        return this.protections;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protections());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionsResponse)) {
            return false;
        }
        ListProtectionsResponse other = (ListProtectionsResponse)((Object)obj);
        return Objects.equals(this.protections(), other.protections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.protections() != null) {
            sb.append("Protections: ").append(this.protections()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protections": {
                return Optional.of(clazz.cast(this.protections()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private List<Protection> protections;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionsResponse model) {
            this.protections(model.protections);
            this.nextToken(model.nextToken);
        }

        public final Collection<Protection.Builder> getProtections() {
            return this.protections != null ? (Collection)this.protections.stream().map(Protection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder protections(Collection<Protection> protections) {
            this.protections = ProtectionsCopier.copy(protections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protections(Protection ... protections) {
            this.protections(Arrays.asList(protections));
            return this;
        }

        public final void setProtections(Collection<Protection.BuilderImpl> protections) {
            this.protections = ProtectionsCopier.copyFromBuilder(protections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProtectionsResponse build() {
            return new ListProtectionsResponse(this);
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    CopyableBuilder<Builder, ListProtectionsResponse> {
        public Builder protections(Collection<Protection> var1);

        public Builder protections(Protection ... var1);

        public Builder nextToken(String var1);
    }
}

