/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.shield.model.AttackSummariesCopier;
import software.amazon.awssdk.services.shield.model.AttackSummary;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttacksResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, ListAttacksResponse> {
    private final List<AttackSummary> attackSummaries;
    private final String nextToken;

    private ListAttacksResponse(BuilderImpl builder) {
        super(builder);
        this.attackSummaries = builder.attackSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<AttackSummary> attackSummaries() {
        return this.attackSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksResponse)) {
            return false;
        }
        ListAttacksResponse other = (ListAttacksResponse)((Object)obj);
        return Objects.equals(this.attackSummaries(), other.attackSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attackSummaries() != null) {
            sb.append("AttackSummaries: ").append(this.attackSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackSummaries": {
                return Optional.of(clazz.cast(this.attackSummaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private List<AttackSummary> attackSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksResponse model) {
            this.attackSummaries(model.attackSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<AttackSummary.Builder> getAttackSummaries() {
            return this.attackSummaries != null ? (Collection)this.attackSummaries.stream().map(AttackSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackSummaries(Collection<AttackSummary> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copy(attackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackSummaries(AttackSummary ... attackSummaries) {
            this.attackSummaries(Arrays.asList(attackSummaries));
            return this;
        }

        public final void setAttackSummaries(Collection<AttackSummary.BuilderImpl> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copyFromBuilder(attackSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAttacksResponse build() {
            return new ListAttacksResponse(this);
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    CopyableBuilder<Builder, ListAttacksResponse> {
        public Builder attackSummaries(Collection<AttackSummary> var1);

        public Builder attackSummaries(AttackSummary ... var1);

        public Builder nextToken(String var1);
    }
}

