/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.SubResourceType;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVector;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVectorListCopier;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.SubResourceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubResourceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, SubResourceSummary> {
    private final String type;
    private final String id;
    private final List<SummarizedAttackVector> attackVectors;
    private final List<SummarizedCounter> counters;

    private SubResourceSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.attackVectors = builder.attackVectors;
        this.counters = builder.counters;
    }

    public SubResourceType type() {
        return SubResourceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public List<SummarizedAttackVector> attackVectors() {
        return this.attackVectors;
    }

    public List<SummarizedCounter> counters() {
        return this.counters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.attackVectors() == null ? 0 : this.attackVectors().hashCode());
        hashCode = 31 * hashCode + (this.counters() == null ? 0 : this.counters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubResourceSummary)) {
            return false;
        }
        SubResourceSummary other = (SubResourceSummary)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.attackVectors() == null ^ this.attackVectors() == null) {
            return false;
        }
        if (other.attackVectors() != null && !other.attackVectors().equals(this.attackVectors())) {
            return false;
        }
        if (other.counters() == null ^ this.counters() == null) {
            return false;
        }
        return other.counters() == null || other.counters().equals(this.counters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.attackVectors() != null) {
            sb.append("AttackVectors: ").append(this.attackVectors()).append(",");
        }
        if (this.counters() != null) {
            sb.append("Counters: ").append(this.counters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "AttackVectors": {
                return Optional.of(clazz.cast(this.attackVectors()));
            }
            case "Counters": {
                return Optional.of(clazz.cast(this.counters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubResourceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private List<SummarizedAttackVector> attackVectors;
        private List<SummarizedCounter> counters;

        private BuilderImpl() {
        }

        private BuilderImpl(SubResourceSummary model) {
            this.type(model.type);
            this.id(model.id);
            this.attackVectors(model.attackVectors);
            this.counters(model.counters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SubResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<SummarizedAttackVector.Builder> getAttackVectors() {
            return this.attackVectors != null ? (Collection)this.attackVectors.stream().map(SummarizedAttackVector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackVectors(Collection<SummarizedAttackVector> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(SummarizedAttackVector ... attackVectors) {
            this.attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        public final void setAttackVectors(Collection<SummarizedAttackVector.BuilderImpl> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copyFromBuilder(attackVectors);
        }

        public final Collection<SummarizedCounter.Builder> getCounters() {
            return this.counters != null ? (Collection)this.counters.stream().map(SummarizedCounter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder counters(Collection<SummarizedCounter> counters) {
            this.counters = SummarizedCounterListCopier.copy(counters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counters(SummarizedCounter ... counters) {
            this.counters(Arrays.asList(counters));
            return this;
        }

        public final void setCounters(Collection<SummarizedCounter.BuilderImpl> counters) {
            this.counters = SummarizedCounterListCopier.copyFromBuilder(counters);
        }

        public SubResourceSummary build() {
            return new SubResourceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubResourceSummary> {
        public Builder type(String var1);

        public Builder type(SubResourceType var1);

        public Builder id(String var1);

        public Builder attackVectors(Collection<SummarizedAttackVector> var1);

        public Builder attackVectors(SummarizedAttackVector ... var1);

        public Builder counters(Collection<SummarizedCounter> var1);

        public Builder counters(SummarizedCounter ... var1);
    }
}

