/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield;

import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.shield.DefaultShieldClientBuilder;
import software.amazon.awssdk.services.shield.ShieldClientBuilder;
import software.amazon.awssdk.services.shield.model.CreateProtectionRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionResponse;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionResponse;
import software.amazon.awssdk.services.shield.model.DeleteSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DeleteSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.InternalErrorException;
import software.amazon.awssdk.services.shield.model.InvalidOperationException;
import software.amazon.awssdk.services.shield.model.InvalidParameterException;
import software.amazon.awssdk.services.shield.model.InvalidResourceException;
import software.amazon.awssdk.services.shield.model.LimitsExceededException;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.LockedSubscriptionException;
import software.amazon.awssdk.services.shield.model.OptimisticLockException;
import software.amazon.awssdk.services.shield.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.shield.model.ResourceNotFoundException;
import software.amazon.awssdk.services.shield.model.ShieldException;

public interface ShieldClient
extends AutoCloseable {
    public static final String SERVICE_NAME = "shield";

    public static ShieldClient create() {
        return (ShieldClient)ShieldClient.builder().build();
    }

    public static ShieldClientBuilder builder() {
        return new DefaultShieldClientBuilder();
    }

    default public CreateProtectionResponse createProtection(CreateProtectionRequest createProtectionRequest) throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException, ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public CreateSubscriptionResponse createSubscription() throws InternalErrorException, ResourceAlreadyExistsException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest createSubscriptionRequest) throws InternalErrorException, ResourceAlreadyExistsException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DeleteProtectionResponse deleteProtection(DeleteProtectionRequest deleteProtectionRequest) throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSubscriptionResponse deleteSubscription() throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSubscriptionResponse deleteSubscription(DeleteSubscriptionRequest deleteSubscriptionRequest) throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAttackResponse describeAttack(DescribeAttackRequest describeAttackRequest) throws InternalErrorException, InvalidParameterException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeProtectionResponse describeProtection(DescribeProtectionRequest describeProtectionRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeSubscriptionResponse describeSubscription() throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeSubscriptionResponse describeSubscription(DescribeSubscriptionRequest describeSubscriptionRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public ListAttacksResponse listAttacks() throws InternalErrorException, InvalidParameterException, InvalidOperationException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public ListAttacksResponse listAttacks(ListAttacksRequest listAttacksRequest) throws InternalErrorException, InvalidParameterException, InvalidOperationException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public ListProtectionsResponse listProtections() throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public ListProtectionsResponse listProtections(ListProtectionsRequest listProtectionsRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

