/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.transform.TimeRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeRange> {
    private final Instant fromInclusive;
    private final Instant toExclusive;

    private TimeRange(BuilderImpl builder) {
        this.fromInclusive = builder.fromInclusive;
        this.toExclusive = builder.toExclusive;
    }

    public Instant fromInclusive() {
        return this.fromInclusive;
    }

    public Instant toExclusive() {
        return this.toExclusive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.toExclusive());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        return Objects.equals(this.fromInclusive(), other.fromInclusive()) && Objects.equals(this.toExclusive(), other.toExclusive());
    }

    public String toString() {
        return ToString.builder((String)"TimeRange").add("FromInclusive", (Object)this.fromInclusive()).add("ToExclusive", (Object)this.toExclusive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromInclusive": {
                return Optional.of(clazz.cast(this.fromInclusive()));
            }
            case "ToExclusive": {
                return Optional.of(clazz.cast(this.toExclusive()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant fromInclusive;
        private Instant toExclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            this.fromInclusive(model.fromInclusive);
            this.toExclusive(model.toExclusive);
        }

        public final Instant getFromInclusive() {
            return this.fromInclusive;
        }

        @Override
        public final Builder fromInclusive(Instant fromInclusive) {
            this.fromInclusive = fromInclusive;
            return this;
        }

        public final void setFromInclusive(Instant fromInclusive) {
            this.fromInclusive = fromInclusive;
        }

        public final Instant getToExclusive() {
            return this.toExclusive;
        }

        @Override
        public final Builder toExclusive(Instant toExclusive) {
            this.toExclusive = toExclusive;
            return this;
        }

        public final void setToExclusive(Instant toExclusive) {
            this.toExclusive = toExclusive;
        }

        public TimeRange build() {
            return new TimeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeRange> {
        public Builder fromInclusive(Instant var1);

        public Builder toExclusive(Instant var1);
    }
}

