/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.AttackVectorDescription;
import software.amazon.awssdk.services.shield.model.AttackVectorDescriptionListCopier;
import software.amazon.awssdk.services.shield.transform.AttackSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttackSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, AttackSummary> {
    private final String attackId;
    private final String resourceArn;
    private final Instant startTime;
    private final Instant endTime;
    private final List<AttackVectorDescription> attackVectors;

    private AttackSummary(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackVectors = builder.attackVectors;
    }

    public String attackId() {
        return this.attackId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<AttackVectorDescription> attackVectors() {
        return this.attackVectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.attackVectors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackSummary)) {
            return false;
        }
        AttackSummary other = (AttackSummary)obj;
        return Objects.equals(this.attackId(), other.attackId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.attackVectors(), other.attackVectors());
    }

    public String toString() {
        return ToString.builder((String)"AttackSummary").add("AttackId", (Object)this.attackId()).add("ResourceArn", (Object)this.resourceArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AttackVectors", this.attackVectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackId": {
                return Optional.of(clazz.cast(this.attackId()));
            }
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "AttackVectors": {
                return Optional.of(clazz.cast(this.attackVectors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private Instant startTime;
        private Instant endTime;
        private List<AttackVectorDescription> attackVectors;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackSummary model) {
            this.attackId(model.attackId);
            this.resourceArn(model.resourceArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.attackVectors(model.attackVectors);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<AttackVectorDescription.Builder> getAttackVectors() {
            return this.attackVectors != null ? (Collection)this.attackVectors.stream().map(AttackVectorDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackVectors(Collection<AttackVectorDescription> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(AttackVectorDescription ... attackVectors) {
            this.attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(Consumer<AttackVectorDescription.Builder> ... attackVectors) {
            this.attackVectors(Stream.of(attackVectors).map(c -> (AttackVectorDescription)((AttackVectorDescription.Builder)AttackVectorDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttackVectors(Collection<AttackVectorDescription.BuilderImpl> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copyFromBuilder(attackVectors);
        }

        public AttackSummary build() {
            return new AttackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttackSummary> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder attackVectors(Collection<AttackVectorDescription> var1);

        public Builder attackVectors(AttackVectorDescription ... var1);

        public Builder attackVectors(Consumer<AttackVectorDescription.Builder> ... var1);
    }
}

