/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.SubResourceType;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVector;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVectorListCopier;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.SubResourceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubResourceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, SubResourceSummary> {
    private final String type;
    private final String id;
    private final List<SummarizedAttackVector> attackVectors;
    private final List<SummarizedCounter> counters;

    private SubResourceSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.attackVectors = builder.attackVectors;
        this.counters = builder.counters;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public List<SummarizedAttackVector> attackVectors() {
        return this.attackVectors;
    }

    public List<SummarizedCounter> counters() {
        return this.counters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.attackVectors() == null ? 0 : this.attackVectors().hashCode());
        hashCode = 31 * hashCode + (this.counters() == null ? 0 : this.counters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubResourceSummary)) {
            return false;
        }
        SubResourceSummary other = (SubResourceSummary)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.attackVectors() == null ^ this.attackVectors() == null) {
            return false;
        }
        if (other.attackVectors() != null && !other.attackVectors().equals(this.attackVectors())) {
            return false;
        }
        if (other.counters() == null ^ this.counters() == null) {
            return false;
        }
        return other.counters() == null || other.counters().equals(this.counters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.attackVectors() != null) {
            sb.append("AttackVectors: ").append(this.attackVectors()).append(",");
        }
        if (this.counters() != null) {
            sb.append("Counters: ").append(this.counters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubResourceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private List<SummarizedAttackVector> attackVectors;
        private List<SummarizedCounter> counters;

        private BuilderImpl() {
        }

        private BuilderImpl(SubResourceSummary model) {
            this.setType(model.type);
            this.setId(model.id);
            this.setAttackVectors(model.attackVectors);
            this.setCounters(model.counters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SubResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(SubResourceType type) {
            this.type(type.toString());
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<SummarizedAttackVector> getAttackVectors() {
            return this.attackVectors;
        }

        @Override
        public final Builder attackVectors(Collection<SummarizedAttackVector> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(SummarizedAttackVector ... attackVectors) {
            if (this.attackVectors == null) {
                this.attackVectors = new ArrayList<SummarizedAttackVector>(attackVectors.length);
            }
            for (SummarizedAttackVector e : attackVectors) {
                this.attackVectors.add(e);
            }
            return this;
        }

        public final void setAttackVectors(Collection<SummarizedAttackVector> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copy(attackVectors);
        }

        @SafeVarargs
        public final void setAttackVectors(SummarizedAttackVector ... attackVectors) {
            if (this.attackVectors == null) {
                this.attackVectors = new ArrayList<SummarizedAttackVector>(attackVectors.length);
            }
            for (SummarizedAttackVector e : attackVectors) {
                this.attackVectors.add(e);
            }
        }

        public final Collection<SummarizedCounter> getCounters() {
            return this.counters;
        }

        @Override
        public final Builder counters(Collection<SummarizedCounter> counters) {
            this.counters = SummarizedCounterListCopier.copy(counters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counters(SummarizedCounter ... counters) {
            if (this.counters == null) {
                this.counters = new ArrayList<SummarizedCounter>(counters.length);
            }
            for (SummarizedCounter e : counters) {
                this.counters.add(e);
            }
            return this;
        }

        public final void setCounters(Collection<SummarizedCounter> counters) {
            this.counters = SummarizedCounterListCopier.copy(counters);
        }

        @SafeVarargs
        public final void setCounters(SummarizedCounter ... counters) {
            if (this.counters == null) {
                this.counters = new ArrayList<SummarizedCounter>(counters.length);
            }
            for (SummarizedCounter e : counters) {
                this.counters.add(e);
            }
        }

        public SubResourceSummary build() {
            return new SubResourceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubResourceSummary> {
        public Builder type(String var1);

        public Builder type(SubResourceType var1);

        public Builder id(String var1);

        public Builder attackVectors(Collection<SummarizedAttackVector> var1);

        public Builder attackVectors(SummarizedAttackVector ... var1);

        public Builder counters(Collection<SummarizedCounter> var1);

        public Builder counters(SummarizedCounter ... var1);
    }
}

