/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StateMachineListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StateMachineListItem> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StateMachineListItem.getter(StateMachineListItem::stateMachineArn)).setter(StateMachineListItem.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StateMachineListItem.getter(StateMachineListItem::name)).setter(StateMachineListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StateMachineListItem.getter(StateMachineListItem::creationDate)).setter(StateMachineListItem.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, NAME_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stateMachineArn;
    private final String name;
    private final Instant creationDate;

    private StateMachineListItem(BuilderImpl builder) {
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.creationDate = builder.creationDate;
    }

    public String stateMachineArn() {
        return this.stateMachineArn;
    }

    public String name() {
        return this.name;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateMachineListItem)) {
            return false;
        }
        StateMachineListItem other = (StateMachineListItem)obj;
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"StateMachineListItem").add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StateMachineListItem, T> g) {
        return obj -> g.apply((StateMachineListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String name;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StateMachineListItem model) {
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.creationDate(model.creationDate);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public StateMachineListItem build() {
            return new StateMachineListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StateMachineListItem> {
        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder creationDate(Instant var1);
    }
}

