/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.EspsCopier;
import software.amazon.awssdk.services.sesv2.model.IpListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainDeliverabilityCampaign
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainDeliverabilityCampaign> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::campaignId)).setter(DomainDeliverabilityCampaign.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUrl").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::imageUrl)).setter(DomainDeliverabilityCampaign.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::subject)).setter(DomainDeliverabilityCampaign.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromAddress").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::fromAddress)).setter(DomainDeliverabilityCampaign.setter(Builder::fromAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()}).build();
    private static final SdkField<List<String>> SENDING_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SendingIps").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::sendingIps)).setter(DomainDeliverabilityCampaign.setter(Builder::sendingIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> FIRST_SEEN_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FirstSeenDateTime").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::firstSeenDateTime)).setter(DomainDeliverabilityCampaign.setter(Builder::firstSeenDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSeenDateTime").build()}).build();
    private static final SdkField<Instant> LAST_SEEN_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSeenDateTime").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::lastSeenDateTime)).setter(DomainDeliverabilityCampaign.setter(Builder::lastSeenDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeenDateTime").build()}).build();
    private static final SdkField<Long> INBOX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InboxCount").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::inboxCount)).setter(DomainDeliverabilityCampaign.setter(Builder::inboxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxCount").build()}).build();
    private static final SdkField<Long> SPAM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SpamCount").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::spamCount)).setter(DomainDeliverabilityCampaign.setter(Builder::spamCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamCount").build()}).build();
    private static final SdkField<Double> READ_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ReadRate").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::readRate)).setter(DomainDeliverabilityCampaign.setter(Builder::readRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadRate").build()}).build();
    private static final SdkField<Double> DELETE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DeleteRate").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::deleteRate)).setter(DomainDeliverabilityCampaign.setter(Builder::deleteRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteRate").build()}).build();
    private static final SdkField<Double> READ_DELETE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ReadDeleteRate").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::readDeleteRate)).setter(DomainDeliverabilityCampaign.setter(Builder::readDeleteRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadDeleteRate").build()}).build();
    private static final SdkField<Long> PROJECTED_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProjectedVolume").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::projectedVolume)).setter(DomainDeliverabilityCampaign.setter(Builder::projectedVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedVolume").build()}).build();
    private static final SdkField<List<String>> ESPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Esps").getter(DomainDeliverabilityCampaign.getter(DomainDeliverabilityCampaign::esps)).setter(DomainDeliverabilityCampaign.setter(Builder::esps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Esps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD, IMAGE_URL_FIELD, SUBJECT_FIELD, FROM_ADDRESS_FIELD, SENDING_IPS_FIELD, FIRST_SEEN_DATE_TIME_FIELD, LAST_SEEN_DATE_TIME_FIELD, INBOX_COUNT_FIELD, SPAM_COUNT_FIELD, READ_RATE_FIELD, DELETE_RATE_FIELD, READ_DELETE_RATE_FIELD, PROJECTED_VOLUME_FIELD, ESPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DomainDeliverabilityCampaign.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String campaignId;
    private final String imageUrl;
    private final String subject;
    private final String fromAddress;
    private final List<String> sendingIps;
    private final Instant firstSeenDateTime;
    private final Instant lastSeenDateTime;
    private final Long inboxCount;
    private final Long spamCount;
    private final Double readRate;
    private final Double deleteRate;
    private final Double readDeleteRate;
    private final Long projectedVolume;
    private final List<String> esps;

    private DomainDeliverabilityCampaign(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.imageUrl = builder.imageUrl;
        this.subject = builder.subject;
        this.fromAddress = builder.fromAddress;
        this.sendingIps = builder.sendingIps;
        this.firstSeenDateTime = builder.firstSeenDateTime;
        this.lastSeenDateTime = builder.lastSeenDateTime;
        this.inboxCount = builder.inboxCount;
        this.spamCount = builder.spamCount;
        this.readRate = builder.readRate;
        this.deleteRate = builder.deleteRate;
        this.readDeleteRate = builder.readDeleteRate;
        this.projectedVolume = builder.projectedVolume;
        this.esps = builder.esps;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final String imageUrl() {
        return this.imageUrl;
    }

    public final String subject() {
        return this.subject;
    }

    public final String fromAddress() {
        return this.fromAddress;
    }

    public final boolean hasSendingIps() {
        return this.sendingIps != null && !(this.sendingIps instanceof SdkAutoConstructList);
    }

    public final List<String> sendingIps() {
        return this.sendingIps;
    }

    public final Instant firstSeenDateTime() {
        return this.firstSeenDateTime;
    }

    public final Instant lastSeenDateTime() {
        return this.lastSeenDateTime;
    }

    public final Long inboxCount() {
        return this.inboxCount;
    }

    public final Long spamCount() {
        return this.spamCount;
    }

    public final Double readRate() {
        return this.readRate;
    }

    public final Double deleteRate() {
        return this.deleteRate;
    }

    public final Double readDeleteRate() {
        return this.readDeleteRate;
    }

    public final Long projectedVolume() {
        return this.projectedVolume;
    }

    public final boolean hasEsps() {
        return this.esps != null && !(this.esps instanceof SdkAutoConstructList);
    }

    public final List<String> esps() {
        return this.esps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSendingIps() ? this.sendingIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeenDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeenDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.spamCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.readRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.readDeleteRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectedVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEsps() ? this.esps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDeliverabilityCampaign)) {
            return false;
        }
        DomainDeliverabilityCampaign other = (DomainDeliverabilityCampaign)obj;
        return Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.fromAddress(), other.fromAddress()) && this.hasSendingIps() == other.hasSendingIps() && Objects.equals(this.sendingIps(), other.sendingIps()) && Objects.equals(this.firstSeenDateTime(), other.firstSeenDateTime()) && Objects.equals(this.lastSeenDateTime(), other.lastSeenDateTime()) && Objects.equals(this.inboxCount(), other.inboxCount()) && Objects.equals(this.spamCount(), other.spamCount()) && Objects.equals(this.readRate(), other.readRate()) && Objects.equals(this.deleteRate(), other.deleteRate()) && Objects.equals(this.readDeleteRate(), other.readDeleteRate()) && Objects.equals(this.projectedVolume(), other.projectedVolume()) && this.hasEsps() == other.hasEsps() && Objects.equals(this.esps(), other.esps());
    }

    public final String toString() {
        return ToString.builder((String)"DomainDeliverabilityCampaign").add("CampaignId", (Object)this.campaignId()).add("ImageUrl", (Object)this.imageUrl()).add("Subject", (Object)this.subject()).add("FromAddress", (Object)this.fromAddress()).add("SendingIps", this.hasSendingIps() ? this.sendingIps() : null).add("FirstSeenDateTime", (Object)this.firstSeenDateTime()).add("LastSeenDateTime", (Object)this.lastSeenDateTime()).add("InboxCount", (Object)this.inboxCount()).add("SpamCount", (Object)this.spamCount()).add("ReadRate", (Object)this.readRate()).add("DeleteRate", (Object)this.deleteRate()).add("ReadDeleteRate", (Object)this.readDeleteRate()).add("ProjectedVolume", (Object)this.projectedVolume()).add("Esps", this.hasEsps() ? this.esps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "ImageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "FromAddress": {
                return Optional.ofNullable(clazz.cast(this.fromAddress()));
            }
            case "SendingIps": {
                return Optional.ofNullable(clazz.cast(this.sendingIps()));
            }
            case "FirstSeenDateTime": {
                return Optional.ofNullable(clazz.cast(this.firstSeenDateTime()));
            }
            case "LastSeenDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastSeenDateTime()));
            }
            case "InboxCount": {
                return Optional.ofNullable(clazz.cast(this.inboxCount()));
            }
            case "SpamCount": {
                return Optional.ofNullable(clazz.cast(this.spamCount()));
            }
            case "ReadRate": {
                return Optional.ofNullable(clazz.cast(this.readRate()));
            }
            case "DeleteRate": {
                return Optional.ofNullable(clazz.cast(this.deleteRate()));
            }
            case "ReadDeleteRate": {
                return Optional.ofNullable(clazz.cast(this.readDeleteRate()));
            }
            case "ProjectedVolume": {
                return Optional.ofNullable(clazz.cast(this.projectedVolume()));
            }
            case "Esps": {
                return Optional.ofNullable(clazz.cast(this.esps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CampaignId", CAMPAIGN_ID_FIELD);
        map.put("ImageUrl", IMAGE_URL_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("FromAddress", FROM_ADDRESS_FIELD);
        map.put("SendingIps", SENDING_IPS_FIELD);
        map.put("FirstSeenDateTime", FIRST_SEEN_DATE_TIME_FIELD);
        map.put("LastSeenDateTime", LAST_SEEN_DATE_TIME_FIELD);
        map.put("InboxCount", INBOX_COUNT_FIELD);
        map.put("SpamCount", SPAM_COUNT_FIELD);
        map.put("ReadRate", READ_RATE_FIELD);
        map.put("DeleteRate", DELETE_RATE_FIELD);
        map.put("ReadDeleteRate", READ_DELETE_RATE_FIELD);
        map.put("ProjectedVolume", PROJECTED_VOLUME_FIELD);
        map.put("Esps", ESPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainDeliverabilityCampaign, T> g) {
        return obj -> g.apply((DomainDeliverabilityCampaign)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String campaignId;
        private String imageUrl;
        private String subject;
        private String fromAddress;
        private List<String> sendingIps = DefaultSdkAutoConstructList.getInstance();
        private Instant firstSeenDateTime;
        private Instant lastSeenDateTime;
        private Long inboxCount;
        private Long spamCount;
        private Double readRate;
        private Double deleteRate;
        private Double readDeleteRate;
        private Long projectedVolume;
        private List<String> esps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDeliverabilityCampaign model) {
            this.campaignId(model.campaignId);
            this.imageUrl(model.imageUrl);
            this.subject(model.subject);
            this.fromAddress(model.fromAddress);
            this.sendingIps(model.sendingIps);
            this.firstSeenDateTime(model.firstSeenDateTime);
            this.lastSeenDateTime(model.lastSeenDateTime);
            this.inboxCount(model.inboxCount);
            this.spamCount(model.spamCount);
            this.readRate(model.readRate);
            this.deleteRate(model.deleteRate);
            this.readDeleteRate(model.readDeleteRate);
            this.projectedVolume(model.projectedVolume);
            this.esps(model.esps);
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final Collection<String> getSendingIps() {
            if (this.sendingIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sendingIps;
        }

        public final void setSendingIps(Collection<String> sendingIps) {
            this.sendingIps = IpListCopier.copy(sendingIps);
        }

        @Override
        public final Builder sendingIps(Collection<String> sendingIps) {
            this.sendingIps = IpListCopier.copy(sendingIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendingIps(String ... sendingIps) {
            this.sendingIps(Arrays.asList(sendingIps));
            return this;
        }

        public final Instant getFirstSeenDateTime() {
            return this.firstSeenDateTime;
        }

        public final void setFirstSeenDateTime(Instant firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
        }

        @Override
        public final Builder firstSeenDateTime(Instant firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            return this;
        }

        public final Instant getLastSeenDateTime() {
            return this.lastSeenDateTime;
        }

        public final void setLastSeenDateTime(Instant lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
        }

        @Override
        public final Builder lastSeenDateTime(Instant lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            return this;
        }

        public final Long getInboxCount() {
            return this.inboxCount;
        }

        public final void setInboxCount(Long inboxCount) {
            this.inboxCount = inboxCount;
        }

        @Override
        public final Builder inboxCount(Long inboxCount) {
            this.inboxCount = inboxCount;
            return this;
        }

        public final Long getSpamCount() {
            return this.spamCount;
        }

        public final void setSpamCount(Long spamCount) {
            this.spamCount = spamCount;
        }

        @Override
        public final Builder spamCount(Long spamCount) {
            this.spamCount = spamCount;
            return this;
        }

        public final Double getReadRate() {
            return this.readRate;
        }

        public final void setReadRate(Double readRate) {
            this.readRate = readRate;
        }

        @Override
        public final Builder readRate(Double readRate) {
            this.readRate = readRate;
            return this;
        }

        public final Double getDeleteRate() {
            return this.deleteRate;
        }

        public final void setDeleteRate(Double deleteRate) {
            this.deleteRate = deleteRate;
        }

        @Override
        public final Builder deleteRate(Double deleteRate) {
            this.deleteRate = deleteRate;
            return this;
        }

        public final Double getReadDeleteRate() {
            return this.readDeleteRate;
        }

        public final void setReadDeleteRate(Double readDeleteRate) {
            this.readDeleteRate = readDeleteRate;
        }

        @Override
        public final Builder readDeleteRate(Double readDeleteRate) {
            this.readDeleteRate = readDeleteRate;
            return this;
        }

        public final Long getProjectedVolume() {
            return this.projectedVolume;
        }

        public final void setProjectedVolume(Long projectedVolume) {
            this.projectedVolume = projectedVolume;
        }

        @Override
        public final Builder projectedVolume(Long projectedVolume) {
            this.projectedVolume = projectedVolume;
            return this;
        }

        public final Collection<String> getEsps() {
            if (this.esps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.esps;
        }

        public final void setEsps(Collection<String> esps) {
            this.esps = EspsCopier.copy(esps);
        }

        @Override
        public final Builder esps(Collection<String> esps) {
            this.esps = EspsCopier.copy(esps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder esps(String ... esps) {
            this.esps(Arrays.asList(esps));
            return this;
        }

        public DomainDeliverabilityCampaign build() {
            return new DomainDeliverabilityCampaign(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainDeliverabilityCampaign> {
        public Builder campaignId(String var1);

        public Builder imageUrl(String var1);

        public Builder subject(String var1);

        public Builder fromAddress(String var1);

        public Builder sendingIps(Collection<String> var1);

        public Builder sendingIps(String ... var1);

        public Builder firstSeenDateTime(Instant var1);

        public Builder lastSeenDateTime(Instant var1);

        public Builder inboxCount(Long var1);

        public Builder spamCount(Long var1);

        public Builder readRate(Double var1);

        public Builder deleteRate(Double var1);

        public Builder readDeleteRate(Double var1);

        public Builder projectedVolume(Long var1);

        public Builder esps(Collection<String> var1);

        public Builder esps(String ... var1);
    }
}

