/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ExportDataSource;
import software.amazon.awssdk.services.sesv2.model.ExportDestination;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportJobRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, CreateExportJobRequest> {
    private static final SdkField<ExportDataSource> EXPORT_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDataSource").getter(CreateExportJobRequest.getter(CreateExportJobRequest::exportDataSource)).setter(CreateExportJobRequest.setter(Builder::exportDataSource)).constructor(ExportDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDataSource").build()}).build();
    private static final SdkField<ExportDestination> EXPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDestination").getter(CreateExportJobRequest.getter(CreateExportJobRequest::exportDestination)).setter(CreateExportJobRequest.setter(Builder::exportDestination)).constructor(ExportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DATA_SOURCE_FIELD, EXPORT_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExportJobRequest.memberNameToFieldInitializer();
    private final ExportDataSource exportDataSource;
    private final ExportDestination exportDestination;

    private CreateExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataSource = builder.exportDataSource;
        this.exportDestination = builder.exportDestination;
    }

    public final ExportDataSource exportDataSource() {
        return this.exportDataSource;
    }

    public final ExportDestination exportDestination() {
        return this.exportDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportJobRequest)) {
            return false;
        }
        CreateExportJobRequest other = (CreateExportJobRequest)((Object)obj);
        return Objects.equals(this.exportDataSource(), other.exportDataSource()) && Objects.equals(this.exportDestination(), other.exportDestination());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExportJobRequest").add("ExportDataSource", (Object)this.exportDataSource()).add("ExportDestination", (Object)this.exportDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportDataSource": {
                return Optional.ofNullable(clazz.cast(this.exportDataSource()));
            }
            case "ExportDestination": {
                return Optional.ofNullable(clazz.cast(this.exportDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExportDataSource", EXPORT_DATA_SOURCE_FIELD);
        map.put("ExportDestination", EXPORT_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExportJobRequest, T> g) {
        return obj -> g.apply((CreateExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private ExportDataSource exportDataSource;
        private ExportDestination exportDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportJobRequest model) {
            super(model);
            this.exportDataSource(model.exportDataSource);
            this.exportDestination(model.exportDestination);
        }

        public final ExportDataSource.Builder getExportDataSource() {
            return this.exportDataSource != null ? this.exportDataSource.toBuilder() : null;
        }

        public final void setExportDataSource(ExportDataSource.BuilderImpl exportDataSource) {
            this.exportDataSource = exportDataSource != null ? exportDataSource.build() : null;
        }

        @Override
        public final Builder exportDataSource(ExportDataSource exportDataSource) {
            this.exportDataSource = exportDataSource;
            return this;
        }

        public final ExportDestination.Builder getExportDestination() {
            return this.exportDestination != null ? this.exportDestination.toBuilder() : null;
        }

        public final void setExportDestination(ExportDestination.BuilderImpl exportDestination) {
            this.exportDestination = exportDestination != null ? exportDestination.build() : null;
        }

        @Override
        public final Builder exportDestination(ExportDestination exportDestination) {
            this.exportDestination = exportDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportJobRequest build() {
            return new CreateExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExportJobRequest> {
        public Builder exportDataSource(ExportDataSource var1);

        default public Builder exportDataSource(Consumer<ExportDataSource.Builder> exportDataSource) {
            return this.exportDataSource((ExportDataSource)((ExportDataSource.Builder)ExportDataSource.builder().applyMutation(exportDataSource)).build());
        }

        public Builder exportDestination(ExportDestination var1);

        default public Builder exportDestination(Consumer<ExportDestination.Builder> exportDestination) {
            return this.exportDestination((ExportDestination)((ExportDestination.Builder)ExportDestination.builder().applyMutation(exportDestination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

