/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sesv2.model.DimensionsCopier;
import software.amazon.awssdk.services.sesv2.model.Metric;
import software.amazon.awssdk.services.sesv2.model.MetricDimensionName;
import software.amazon.awssdk.services.sesv2.model.MetricNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMetricDataQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetMetricDataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(BatchGetMetricDataQuery.getter(BatchGetMetricDataQuery::id)).setter(BatchGetMetricDataQuery.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(BatchGetMetricDataQuery.getter(BatchGetMetricDataQuery::namespaceAsString)).setter(BatchGetMetricDataQuery.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(BatchGetMetricDataQuery.getter(BatchGetMetricDataQuery::metricAsString)).setter(BatchGetMetricDataQuery.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Dimensions").getter(BatchGetMetricDataQuery.getter(BatchGetMetricDataQuery::dimensionsAsStrings)).setter(BatchGetMetricDataQuery.setter(Builder::dimensionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(BatchGetMetricDataQuery.getter(BatchGetMetricDataQuery::startDate)).setter(BatchGetMetricDataQuery.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(BatchGetMetricDataQuery.getter(BatchGetMetricDataQuery::endDate)).setter(BatchGetMetricDataQuery.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAMESPACE_FIELD, METRIC_FIELD, DIMENSIONS_FIELD, START_DATE_FIELD, END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetMetricDataQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String namespace;
    private final String metric;
    private final Map<String, String> dimensions;
    private final Instant startDate;
    private final Instant endDate;

    private BatchGetMetricDataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.namespace = builder.namespace;
        this.metric = builder.metric;
        this.dimensions = builder.dimensions;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    public final String id() {
        return this.id;
    }

    public final MetricNamespace namespace() {
        return MetricNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final Metric metric() {
        return Metric.fromValue(this.metric);
    }

    public final String metricAsString() {
        return this.metric;
    }

    public final Map<MetricDimensionName, String> dimensions() {
        return DimensionsCopier.copyStringToEnum(this.dimensions);
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dimensionsAsStrings() {
        return this.dimensions;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricDataQuery)) {
            return false;
        }
        BatchGetMetricDataQuery other = (BatchGetMetricDataQuery)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && Objects.equals(this.metricAsString(), other.metricAsString()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensionsAsStrings(), other.dimensionsAsStrings()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMetricDataQuery").add("Id", (Object)this.id()).add("Namespace", (Object)this.namespaceAsString()).add("Metric", (Object)this.metricAsString()).add("Dimensions", this.hasDimensions() ? this.dimensionsAsStrings() : null).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metricAsString()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensionsAsStrings()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricDataQuery, T> g) {
        return obj -> g.apply((BatchGetMetricDataQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String namespace;
        private String metric;
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private Instant startDate;
        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricDataQuery model) {
            this.id(model.id);
            this.namespace(model.namespace);
            this.metric(model.metric);
            this.dimensionsWithStrings(model.dimensions);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(MetricNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final Map<String, String> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensionsWithStrings(Map<String, String> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        public final Builder dimensions(Map<MetricDimensionName, String> dimensions) {
            this.dimensions = DimensionsCopier.copyEnumToString(dimensions);
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public BatchGetMetricDataQuery build() {
            return new BatchGetMetricDataQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetMetricDataQuery> {
        public Builder id(String var1);

        public Builder namespace(String var1);

        public Builder namespace(MetricNamespace var1);

        public Builder metric(String var1);

        public Builder metric(Metric var1);

        public Builder dimensionsWithStrings(Map<String, String> var1);

        public Builder dimensions(Map<MetricDimensionName, String> var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);
    }
}

