/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.AttachmentContentDisposition;
import software.amazon.awssdk.services.sesv2.model.AttachmentContentTransferEncoding;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attachment> {
    private static final SdkField<SdkBytes> RAW_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("RawContent").getter(Attachment.getter(Attachment::rawContent)).setter(Attachment.setter(Builder::rawContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()}).build();
    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentDisposition").getter(Attachment.getter(Attachment::contentDispositionAsString)).setter(Attachment.setter(Builder::contentDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDisposition").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(Attachment.getter(Attachment::fileName)).setter(Attachment.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()}).build();
    private static final SdkField<String> CONTENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentDescription").getter(Attachment.getter(Attachment::contentDescription)).setter(Attachment.setter(Builder::contentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDescription").build()}).build();
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentId").getter(Attachment.getter(Attachment::contentId)).setter(Attachment.setter(Builder::contentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentId").build()}).build();
    private static final SdkField<String> CONTENT_TRANSFER_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentTransferEncoding").getter(Attachment.getter(Attachment::contentTransferEncodingAsString)).setter(Attachment.setter(Builder::contentTransferEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTransferEncoding").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(Attachment.getter(Attachment::contentType)).setter(Attachment.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_CONTENT_FIELD, CONTENT_DISPOSITION_FIELD, FILE_NAME_FIELD, CONTENT_DESCRIPTION_FIELD, CONTENT_ID_FIELD, CONTENT_TRANSFER_ENCODING_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Attachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes rawContent;
    private final String contentDisposition;
    private final String fileName;
    private final String contentDescription;
    private final String contentId;
    private final String contentTransferEncoding;
    private final String contentType;

    private Attachment(BuilderImpl builder) {
        this.rawContent = builder.rawContent;
        this.contentDisposition = builder.contentDisposition;
        this.fileName = builder.fileName;
        this.contentDescription = builder.contentDescription;
        this.contentId = builder.contentId;
        this.contentTransferEncoding = builder.contentTransferEncoding;
        this.contentType = builder.contentType;
    }

    public final SdkBytes rawContent() {
        return this.rawContent;
    }

    public final AttachmentContentDisposition contentDisposition() {
        return AttachmentContentDisposition.fromValue(this.contentDisposition);
    }

    public final String contentDispositionAsString() {
        return this.contentDisposition;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String contentDescription() {
        return this.contentDescription;
    }

    public final String contentId() {
        return this.contentId;
    }

    public final AttachmentContentTransferEncoding contentTransferEncoding() {
        return AttachmentContentTransferEncoding.fromValue(this.contentTransferEncoding);
    }

    public final String contentTransferEncodingAsString() {
        return this.contentTransferEncoding;
    }

    public final String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTransferEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.contentDispositionAsString(), other.contentDispositionAsString()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.contentDescription(), other.contentDescription()) && Objects.equals(this.contentId(), other.contentId()) && Objects.equals(this.contentTransferEncodingAsString(), other.contentTransferEncodingAsString()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"Attachment").add("RawContent", (Object)this.rawContent()).add("ContentDisposition", (Object)this.contentDispositionAsString()).add("FileName", (Object)this.fileName()).add("ContentDescription", (Object)this.contentDescription()).add("ContentId", (Object)this.contentId()).add("ContentTransferEncoding", (Object)this.contentTransferEncodingAsString()).add("ContentType", (Object)this.contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RawContent": {
                return Optional.ofNullable(clazz.cast(this.rawContent()));
            }
            case "ContentDisposition": {
                return Optional.ofNullable(clazz.cast(this.contentDispositionAsString()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "ContentDescription": {
                return Optional.ofNullable(clazz.cast(this.contentDescription()));
            }
            case "ContentId": {
                return Optional.ofNullable(clazz.cast(this.contentId()));
            }
            case "ContentTransferEncoding": {
                return Optional.ofNullable(clazz.cast(this.contentTransferEncodingAsString()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RawContent", RAW_CONTENT_FIELD);
        map.put("ContentDisposition", CONTENT_DISPOSITION_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("ContentDescription", CONTENT_DESCRIPTION_FIELD);
        map.put("ContentId", CONTENT_ID_FIELD);
        map.put("ContentTransferEncoding", CONTENT_TRANSFER_ENCODING_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes rawContent;
        private String contentDisposition;
        private String fileName;
        private String contentDescription;
        private String contentId;
        private String contentTransferEncoding;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.rawContent(model.rawContent);
            this.contentDisposition(model.contentDisposition);
            this.fileName(model.fileName);
            this.contentDescription(model.contentDescription);
            this.contentId(model.contentId);
            this.contentTransferEncoding(model.contentTransferEncoding);
            this.contentType(model.contentType);
        }

        public final ByteBuffer getRawContent() {
            return this.rawContent == null ? null : this.rawContent.asByteBuffer();
        }

        public final void setRawContent(ByteBuffer rawContent) {
            this.rawContent(rawContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)rawContent));
        }

        @Override
        public final Builder rawContent(SdkBytes rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentDisposition(AttachmentContentDisposition contentDisposition) {
            this.contentDisposition(contentDisposition == null ? null : contentDisposition.toString());
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getContentDescription() {
            return this.contentDescription;
        }

        public final void setContentDescription(String contentDescription) {
            this.contentDescription = contentDescription;
        }

        @Override
        public final Builder contentDescription(String contentDescription) {
            this.contentDescription = contentDescription;
            return this;
        }

        public final String getContentId() {
            return this.contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getContentTransferEncoding() {
            return this.contentTransferEncoding;
        }

        public final void setContentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
        }

        @Override
        public final Builder contentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
            return this;
        }

        @Override
        public final Builder contentTransferEncoding(AttachmentContentTransferEncoding contentTransferEncoding) {
            this.contentTransferEncoding(contentTransferEncoding == null ? null : contentTransferEncoding.toString());
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attachment> {
        public Builder rawContent(SdkBytes var1);

        public Builder contentDisposition(String var1);

        public Builder contentDisposition(AttachmentContentDisposition var1);

        public Builder fileName(String var1);

        public Builder contentDescription(String var1);

        public Builder contentId(String var1);

        public Builder contentTransferEncoding(String var1);

        public Builder contentTransferEncoding(AttachmentContentTransferEncoding var1);

        public Builder contentType(String var1);
    }
}

