/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsRequest;
import software.amazon.awssdk.services.sesv2.model.ListMultiRegionEndpointsResponse;
import software.amazon.awssdk.services.sesv2.model.MultiRegionEndpoint;

public class ListMultiRegionEndpointsPublisher
implements SdkPublisher<ListMultiRegionEndpointsResponse> {
    private final SesV2AsyncClient client;
    private final ListMultiRegionEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultiRegionEndpointsPublisher(SesV2AsyncClient client, ListMultiRegionEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultiRegionEndpointsPublisher(SesV2AsyncClient client, ListMultiRegionEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultiRegionEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultiRegionEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MultiRegionEndpoint> multiRegionEndpoints() {
        Function<ListMultiRegionEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiRegionEndpoints() != null) {
                return response.multiRegionEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMultiRegionEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMultiRegionEndpointsResponseFetcher
    implements AsyncPageFetcher<ListMultiRegionEndpointsResponse> {
        private ListMultiRegionEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiRegionEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMultiRegionEndpointsResponse> nextPage(ListMultiRegionEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiRegionEndpointsPublisher.this.client.listMultiRegionEndpoints(ListMultiRegionEndpointsPublisher.this.firstRequest);
            }
            return ListMultiRegionEndpointsPublisher.this.client.listMultiRegionEndpoints((ListMultiRegionEndpointsRequest)((Object)ListMultiRegionEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

