/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.ScalingMode;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDedicatedIpPoolRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, CreateDedicatedIpPoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(CreateDedicatedIpPoolRequest.getter(CreateDedicatedIpPoolRequest::poolName)).setter(CreateDedicatedIpPoolRequest.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDedicatedIpPoolRequest.getter(CreateDedicatedIpPoolRequest::tags)).setter(CreateDedicatedIpPoolRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCALING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingMode").getter(CreateDedicatedIpPoolRequest.getter(CreateDedicatedIpPoolRequest::scalingModeAsString)).setter(CreateDedicatedIpPoolRequest.setter(Builder::scalingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD, TAGS_FIELD, SCALING_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDedicatedIpPoolRequest.memberNameToFieldInitializer();
    private final String poolName;
    private final List<Tag> tags;
    private final String scalingMode;

    private CreateDedicatedIpPoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.tags = builder.tags;
        this.scalingMode = builder.scalingMode;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ScalingMode scalingMode() {
        return ScalingMode.fromValue(this.scalingMode);
    }

    public final String scalingModeAsString() {
        return this.scalingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDedicatedIpPoolRequest)) {
            return false;
        }
        CreateDedicatedIpPoolRequest other = (CreateDedicatedIpPoolRequest)((Object)obj);
        return Objects.equals(this.poolName(), other.poolName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.scalingModeAsString(), other.scalingModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDedicatedIpPoolRequest").add("PoolName", (Object)this.poolName()).add("Tags", this.hasTags() ? this.tags() : null).add("ScalingMode", (Object)this.scalingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ScalingMode": {
                return Optional.ofNullable(clazz.cast(this.scalingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ScalingMode", SCALING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDedicatedIpPoolRequest, T> g) {
        return obj -> g.apply((CreateDedicatedIpPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String poolName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String scalingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDedicatedIpPoolRequest model) {
            super(model);
            this.poolName(model.poolName);
            this.tags(model.tags);
            this.scalingMode(model.scalingMode);
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScalingMode() {
            return this.scalingMode;
        }

        public final void setScalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
        }

        @Override
        public final Builder scalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
            return this;
        }

        @Override
        public final Builder scalingMode(ScalingMode scalingMode) {
            this.scalingMode(scalingMode == null ? null : scalingMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDedicatedIpPoolRequest build() {
            return new CreateDedicatedIpPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDedicatedIpPoolRequest> {
        public Builder poolName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder scalingMode(String var1);

        public Builder scalingMode(ScalingMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

