/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DeliveryEventType;
import software.amazon.awssdk.services.sesv2.model.EmailAddressFilterListCopier;
import software.amazon.awssdk.services.sesv2.model.EmailSubjectFilterListCopier;
import software.amazon.awssdk.services.sesv2.model.EngagementEventType;
import software.amazon.awssdk.services.sesv2.model.IspFilterListCopier;
import software.amazon.awssdk.services.sesv2.model.LastDeliveryEventListCopier;
import software.amazon.awssdk.services.sesv2.model.LastEngagementEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageInsightsFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageInsightsFilters> {
    private static final SdkField<List<String>> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FromEmailAddress").getter(MessageInsightsFilters.getter(MessageInsightsFilters::fromEmailAddress)).setter(MessageInsightsFilters.setter(Builder::fromEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destination").getter(MessageInsightsFilters.getter(MessageInsightsFilters::destination)).setter(MessageInsightsFilters.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subject").getter(MessageInsightsFilters.getter(MessageInsightsFilters::subject)).setter(MessageInsightsFilters.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ISP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Isp").getter(MessageInsightsFilters.getter(MessageInsightsFilters::isp)).setter(MessageInsightsFilters.setter(Builder::isp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Isp").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAST_DELIVERY_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LastDeliveryEvent").getter(MessageInsightsFilters.getter(MessageInsightsFilters::lastDeliveryEventAsStrings)).setter(MessageInsightsFilters.setter(Builder::lastDeliveryEventWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeliveryEvent").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAST_ENGAGEMENT_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LastEngagementEvent").getter(MessageInsightsFilters.getter(MessageInsightsFilters::lastEngagementEventAsStrings)).setter(MessageInsightsFilters.setter(Builder::lastEngagementEventWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEngagementEvent").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_EMAIL_ADDRESS_FIELD, DESTINATION_FIELD, SUBJECT_FIELD, ISP_FIELD, LAST_DELIVERY_EVENT_FIELD, LAST_ENGAGEMENT_EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageInsightsFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> fromEmailAddress;
    private final List<String> destination;
    private final List<String> subject;
    private final List<String> isp;
    private final List<String> lastDeliveryEvent;
    private final List<String> lastEngagementEvent;

    private MessageInsightsFilters(BuilderImpl builder) {
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destination = builder.destination;
        this.subject = builder.subject;
        this.isp = builder.isp;
        this.lastDeliveryEvent = builder.lastDeliveryEvent;
        this.lastEngagementEvent = builder.lastEngagementEvent;
    }

    public final boolean hasFromEmailAddress() {
        return this.fromEmailAddress != null && !(this.fromEmailAddress instanceof SdkAutoConstructList);
    }

    public final List<String> fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final boolean hasDestination() {
        return this.destination != null && !(this.destination instanceof SdkAutoConstructList);
    }

    public final List<String> destination() {
        return this.destination;
    }

    public final boolean hasSubject() {
        return this.subject != null && !(this.subject instanceof SdkAutoConstructList);
    }

    public final List<String> subject() {
        return this.subject;
    }

    public final boolean hasIsp() {
        return this.isp != null && !(this.isp instanceof SdkAutoConstructList);
    }

    public final List<String> isp() {
        return this.isp;
    }

    public final List<DeliveryEventType> lastDeliveryEvent() {
        return LastDeliveryEventListCopier.copyStringToEnum(this.lastDeliveryEvent);
    }

    public final boolean hasLastDeliveryEvent() {
        return this.lastDeliveryEvent != null && !(this.lastDeliveryEvent instanceof SdkAutoConstructList);
    }

    public final List<String> lastDeliveryEventAsStrings() {
        return this.lastDeliveryEvent;
    }

    public final List<EngagementEventType> lastEngagementEvent() {
        return LastEngagementEventListCopier.copyStringToEnum(this.lastEngagementEvent);
    }

    public final boolean hasLastEngagementEvent() {
        return this.lastEngagementEvent != null && !(this.lastEngagementEvent instanceof SdkAutoConstructList);
    }

    public final List<String> lastEngagementEventAsStrings() {
        return this.lastEngagementEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFromEmailAddress() ? this.fromEmailAddress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestination() ? this.destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubject() ? this.subject() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIsp() ? this.isp() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastDeliveryEvent() ? this.lastDeliveryEventAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastEngagementEvent() ? this.lastEngagementEventAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageInsightsFilters)) {
            return false;
        }
        MessageInsightsFilters other = (MessageInsightsFilters)obj;
        return this.hasFromEmailAddress() == other.hasFromEmailAddress() && Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && this.hasDestination() == other.hasDestination() && Objects.equals(this.destination(), other.destination()) && this.hasSubject() == other.hasSubject() && Objects.equals(this.subject(), other.subject()) && this.hasIsp() == other.hasIsp() && Objects.equals(this.isp(), other.isp()) && this.hasLastDeliveryEvent() == other.hasLastDeliveryEvent() && Objects.equals(this.lastDeliveryEventAsStrings(), other.lastDeliveryEventAsStrings()) && this.hasLastEngagementEvent() == other.hasLastEngagementEvent() && Objects.equals(this.lastEngagementEventAsStrings(), other.lastEngagementEventAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"MessageInsightsFilters").add("FromEmailAddress", (Object)(this.fromEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Destination", (Object)(this.destination() == null ? null : "*** Sensitive Data Redacted ***")).add("Subject", (Object)(this.subject() == null ? null : "*** Sensitive Data Redacted ***")).add("Isp", this.hasIsp() ? this.isp() : null).add("LastDeliveryEvent", this.hasLastDeliveryEvent() ? this.lastDeliveryEventAsStrings() : null).add("LastEngagementEvent", this.hasLastEngagementEvent() ? this.lastEngagementEventAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Isp": {
                return Optional.ofNullable(clazz.cast(this.isp()));
            }
            case "LastDeliveryEvent": {
                return Optional.ofNullable(clazz.cast(this.lastDeliveryEventAsStrings()));
            }
            case "LastEngagementEvent": {
                return Optional.ofNullable(clazz.cast(this.lastEngagementEventAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Isp", ISP_FIELD);
        map.put("LastDeliveryEvent", LAST_DELIVERY_EVENT_FIELD);
        map.put("LastEngagementEvent", LAST_ENGAGEMENT_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageInsightsFilters, T> g) {
        return obj -> g.apply((MessageInsightsFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> fromEmailAddress = DefaultSdkAutoConstructList.getInstance();
        private List<String> destination = DefaultSdkAutoConstructList.getInstance();
        private List<String> subject = DefaultSdkAutoConstructList.getInstance();
        private List<String> isp = DefaultSdkAutoConstructList.getInstance();
        private List<String> lastDeliveryEvent = DefaultSdkAutoConstructList.getInstance();
        private List<String> lastEngagementEvent = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageInsightsFilters model) {
            this.fromEmailAddress(model.fromEmailAddress);
            this.destination(model.destination);
            this.subject(model.subject);
            this.isp(model.isp);
            this.lastDeliveryEventWithStrings(model.lastDeliveryEvent);
            this.lastEngagementEventWithStrings(model.lastEngagementEvent);
        }

        public final Collection<String> getFromEmailAddress() {
            if (this.fromEmailAddress instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fromEmailAddress;
        }

        public final void setFromEmailAddress(Collection<String> fromEmailAddress) {
            this.fromEmailAddress = EmailAddressFilterListCopier.copy(fromEmailAddress);
        }

        @Override
        public final Builder fromEmailAddress(Collection<String> fromEmailAddress) {
            this.fromEmailAddress = EmailAddressFilterListCopier.copy(fromEmailAddress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromEmailAddress(String ... fromEmailAddress) {
            this.fromEmailAddress(Arrays.asList(fromEmailAddress));
            return this;
        }

        public final Collection<String> getDestination() {
            if (this.destination instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destination;
        }

        public final void setDestination(Collection<String> destination) {
            this.destination = EmailAddressFilterListCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<String> destination) {
            this.destination = EmailAddressFilterListCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(String ... destination) {
            this.destination(Arrays.asList(destination));
            return this;
        }

        public final Collection<String> getSubject() {
            if (this.subject instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subject;
        }

        public final void setSubject(Collection<String> subject) {
            this.subject = EmailSubjectFilterListCopier.copy(subject);
        }

        @Override
        public final Builder subject(Collection<String> subject) {
            this.subject = EmailSubjectFilterListCopier.copy(subject);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subject(String ... subject) {
            this.subject(Arrays.asList(subject));
            return this;
        }

        public final Collection<String> getIsp() {
            if (this.isp instanceof SdkAutoConstructList) {
                return null;
            }
            return this.isp;
        }

        public final void setIsp(Collection<String> isp) {
            this.isp = IspFilterListCopier.copy(isp);
        }

        @Override
        public final Builder isp(Collection<String> isp) {
            this.isp = IspFilterListCopier.copy(isp);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isp(String ... isp) {
            this.isp(Arrays.asList(isp));
            return this;
        }

        public final Collection<String> getLastDeliveryEvent() {
            if (this.lastDeliveryEvent instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lastDeliveryEvent;
        }

        public final void setLastDeliveryEvent(Collection<String> lastDeliveryEvent) {
            this.lastDeliveryEvent = LastDeliveryEventListCopier.copy(lastDeliveryEvent);
        }

        @Override
        public final Builder lastDeliveryEventWithStrings(Collection<String> lastDeliveryEvent) {
            this.lastDeliveryEvent = LastDeliveryEventListCopier.copy(lastDeliveryEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastDeliveryEventWithStrings(String ... lastDeliveryEvent) {
            this.lastDeliveryEventWithStrings(Arrays.asList(lastDeliveryEvent));
            return this;
        }

        @Override
        public final Builder lastDeliveryEvent(Collection<DeliveryEventType> lastDeliveryEvent) {
            this.lastDeliveryEvent = LastDeliveryEventListCopier.copyEnumToString(lastDeliveryEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastDeliveryEvent(DeliveryEventType ... lastDeliveryEvent) {
            this.lastDeliveryEvent(Arrays.asList(lastDeliveryEvent));
            return this;
        }

        public final Collection<String> getLastEngagementEvent() {
            if (this.lastEngagementEvent instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lastEngagementEvent;
        }

        public final void setLastEngagementEvent(Collection<String> lastEngagementEvent) {
            this.lastEngagementEvent = LastEngagementEventListCopier.copy(lastEngagementEvent);
        }

        @Override
        public final Builder lastEngagementEventWithStrings(Collection<String> lastEngagementEvent) {
            this.lastEngagementEvent = LastEngagementEventListCopier.copy(lastEngagementEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastEngagementEventWithStrings(String ... lastEngagementEvent) {
            this.lastEngagementEventWithStrings(Arrays.asList(lastEngagementEvent));
            return this;
        }

        @Override
        public final Builder lastEngagementEvent(Collection<EngagementEventType> lastEngagementEvent) {
            this.lastEngagementEvent = LastEngagementEventListCopier.copyEnumToString(lastEngagementEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastEngagementEvent(EngagementEventType ... lastEngagementEvent) {
            this.lastEngagementEvent(Arrays.asList(lastEngagementEvent));
            return this;
        }

        public MessageInsightsFilters build() {
            return new MessageInsightsFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageInsightsFilters> {
        public Builder fromEmailAddress(Collection<String> var1);

        public Builder fromEmailAddress(String ... var1);

        public Builder destination(Collection<String> var1);

        public Builder destination(String ... var1);

        public Builder subject(Collection<String> var1);

        public Builder subject(String ... var1);

        public Builder isp(Collection<String> var1);

        public Builder isp(String ... var1);

        public Builder lastDeliveryEventWithStrings(Collection<String> var1);

        public Builder lastDeliveryEventWithStrings(String ... var1);

        public Builder lastDeliveryEvent(Collection<DeliveryEventType> var1);

        public Builder lastDeliveryEvent(DeliveryEventType ... var1);

        public Builder lastEngagementEventWithStrings(Collection<String> var1);

        public Builder lastEngagementEventWithStrings(String ... var1);

        public Builder lastEngagementEvent(Collection<EngagementEventType> var1);

        public Builder lastEngagementEvent(EngagementEventType ... var1);
    }
}

