/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.EmailInsights;
import software.amazon.awssdk.services.sesv2.model.EmailInsightsListCopier;
import software.amazon.awssdk.services.sesv2.model.MessageTag;
import software.amazon.awssdk.services.sesv2.model.MessageTagListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMessageInsightsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetMessageInsightsResponse> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(GetMessageInsightsResponse.getter(GetMessageInsightsResponse::messageId)).setter(GetMessageInsightsResponse.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromEmailAddress").getter(GetMessageInsightsResponse.getter(GetMessageInsightsResponse::fromEmailAddress)).setter(GetMessageInsightsResponse.setter(Builder::fromEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(GetMessageInsightsResponse.getter(GetMessageInsightsResponse::subject)).setter(GetMessageInsightsResponse.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<List<MessageTag>> EMAIL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmailTags").getter(GetMessageInsightsResponse.getter(GetMessageInsightsResponse::emailTags)).setter(GetMessageInsightsResponse.setter(Builder::emailTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EmailInsights>> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Insights").getter(GetMessageInsightsResponse.getter(GetMessageInsightsResponse::insights)).setter(GetMessageInsightsResponse.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailInsights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, FROM_EMAIL_ADDRESS_FIELD, SUBJECT_FIELD, EMAIL_TAGS_FIELD, INSIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMessageInsightsResponse.memberNameToFieldInitializer();
    private final String messageId;
    private final String fromEmailAddress;
    private final String subject;
    private final List<MessageTag> emailTags;
    private final List<EmailInsights> insights;

    private GetMessageInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.subject = builder.subject;
        this.emailTags = builder.emailTags;
        this.insights = builder.insights;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final String subject() {
        return this.subject;
    }

    public final boolean hasEmailTags() {
        return this.emailTags != null && !(this.emailTags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> emailTags() {
        return this.emailTags;
    }

    public final boolean hasInsights() {
        return this.insights != null && !(this.insights instanceof SdkAutoConstructList);
    }

    public final List<EmailInsights> insights() {
        return this.insights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmailTags() ? this.emailTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsights() ? this.insights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMessageInsightsResponse)) {
            return false;
        }
        GetMessageInsightsResponse other = (GetMessageInsightsResponse)((Object)obj);
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.subject(), other.subject()) && this.hasEmailTags() == other.hasEmailTags() && Objects.equals(this.emailTags(), other.emailTags()) && this.hasInsights() == other.hasInsights() && Objects.equals(this.insights(), other.insights());
    }

    public final String toString() {
        return ToString.builder((String)"GetMessageInsightsResponse").add("MessageId", (Object)this.messageId()).add("FromEmailAddress", (Object)(this.fromEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Subject", (Object)(this.subject() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailTags", this.hasEmailTags() ? this.emailTags() : null).add("Insights", this.hasInsights() ? this.insights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "EmailTags": {
                return Optional.ofNullable(clazz.cast(this.emailTags()));
            }
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("EmailTags", EMAIL_TAGS_FIELD);
        map.put("Insights", INSIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMessageInsightsResponse, T> g) {
        return obj -> g.apply((GetMessageInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String messageId;
        private String fromEmailAddress;
        private String subject;
        private List<MessageTag> emailTags = DefaultSdkAutoConstructList.getInstance();
        private List<EmailInsights> insights = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMessageInsightsResponse model) {
            super(model);
            this.messageId(model.messageId);
            this.fromEmailAddress(model.fromEmailAddress);
            this.subject(model.subject);
            this.emailTags(model.emailTags);
            this.insights(model.insights);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getFromEmailAddress() {
            return this.fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final List<MessageTag.Builder> getEmailTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.emailTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailTags(Collection<MessageTag.BuilderImpl> emailTags) {
            this.emailTags = MessageTagListCopier.copyFromBuilder(emailTags);
        }

        @Override
        public final Builder emailTags(Collection<MessageTag> emailTags) {
            this.emailTags = MessageTagListCopier.copy(emailTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(MessageTag ... emailTags) {
            this.emailTags(Arrays.asList(emailTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(Consumer<MessageTag.Builder> ... emailTags) {
            this.emailTags(Stream.of(emailTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EmailInsights.Builder> getInsights() {
            List<EmailInsights.Builder> result = EmailInsightsListCopier.copyToBuilder(this.insights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsights(Collection<EmailInsights.BuilderImpl> insights) {
            this.insights = EmailInsightsListCopier.copyFromBuilder(insights);
        }

        @Override
        public final Builder insights(Collection<EmailInsights> insights) {
            this.insights = EmailInsightsListCopier.copy(insights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(EmailInsights ... insights) {
            this.insights(Arrays.asList(insights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insights(Consumer<EmailInsights.Builder> ... insights) {
            this.insights(Stream.of(insights).map(c -> (EmailInsights)((EmailInsights.Builder)EmailInsights.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMessageInsightsResponse build() {
            return new GetMessageInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMessageInsightsResponse> {
        public Builder messageId(String var1);

        public Builder fromEmailAddress(String var1);

        public Builder subject(String var1);

        public Builder emailTags(Collection<MessageTag> var1);

        public Builder emailTags(MessageTag ... var1);

        public Builder emailTags(Consumer<MessageTag.Builder> ... var1);

        public Builder insights(Collection<EmailInsights> var1);

        public Builder insights(EmailInsights ... var1);

        public Builder insights(Consumer<EmailInsights.Builder> ... var1);
    }
}

