/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.ArchivingOptions;
import software.amazon.awssdk.services.sesv2.model.DeliveryOptions;
import software.amazon.awssdk.services.sesv2.model.ReputationOptions;
import software.amazon.awssdk.services.sesv2.model.SendingOptions;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.SuppressionOptions;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.services.sesv2.model.TrackingOptions;
import software.amazon.awssdk.services.sesv2.model.VdmOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationSetRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, CreateConfigurationSetRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::configurationSetName)).setter(CreateConfigurationSetRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<TrackingOptions> TRACKING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrackingOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::trackingOptions)).setter(CreateConfigurationSetRequest.setter(Builder::trackingOptions)).constructor(TrackingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingOptions").build()}).build();
    private static final SdkField<DeliveryOptions> DELIVERY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::deliveryOptions)).setter(CreateConfigurationSetRequest.setter(Builder::deliveryOptions)).constructor(DeliveryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryOptions").build()}).build();
    private static final SdkField<ReputationOptions> REPUTATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReputationOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::reputationOptions)).setter(CreateConfigurationSetRequest.setter(Builder::reputationOptions)).constructor(ReputationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationOptions").build()}).build();
    private static final SdkField<SendingOptions> SENDING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SendingOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::sendingOptions)).setter(CreateConfigurationSetRequest.setter(Builder::sendingOptions)).constructor(SendingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingOptions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::tags)).setter(CreateConfigurationSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SuppressionOptions> SUPPRESSION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SuppressionOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::suppressionOptions)).setter(CreateConfigurationSetRequest.setter(Builder::suppressionOptions)).constructor(SuppressionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressionOptions").build()}).build();
    private static final SdkField<VdmOptions> VDM_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VdmOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::vdmOptions)).setter(CreateConfigurationSetRequest.setter(Builder::vdmOptions)).constructor(VdmOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmOptions").build()}).build();
    private static final SdkField<ArchivingOptions> ARCHIVING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArchivingOptions").getter(CreateConfigurationSetRequest.getter(CreateConfigurationSetRequest::archivingOptions)).setter(CreateConfigurationSetRequest.setter(Builder::archivingOptions)).constructor(ArchivingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivingOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, TRACKING_OPTIONS_FIELD, DELIVERY_OPTIONS_FIELD, REPUTATION_OPTIONS_FIELD, SENDING_OPTIONS_FIELD, TAGS_FIELD, SUPPRESSION_OPTIONS_FIELD, VDM_OPTIONS_FIELD, ARCHIVING_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConfigurationSetRequest.memberNameToFieldInitializer();
    private final String configurationSetName;
    private final TrackingOptions trackingOptions;
    private final DeliveryOptions deliveryOptions;
    private final ReputationOptions reputationOptions;
    private final SendingOptions sendingOptions;
    private final List<Tag> tags;
    private final SuppressionOptions suppressionOptions;
    private final VdmOptions vdmOptions;
    private final ArchivingOptions archivingOptions;

    private CreateConfigurationSetRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
        this.deliveryOptions = builder.deliveryOptions;
        this.reputationOptions = builder.reputationOptions;
        this.sendingOptions = builder.sendingOptions;
        this.tags = builder.tags;
        this.suppressionOptions = builder.suppressionOptions;
        this.vdmOptions = builder.vdmOptions;
        this.archivingOptions = builder.archivingOptions;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final TrackingOptions trackingOptions() {
        return this.trackingOptions;
    }

    public final DeliveryOptions deliveryOptions() {
        return this.deliveryOptions;
    }

    public final ReputationOptions reputationOptions() {
        return this.reputationOptions;
    }

    public final SendingOptions sendingOptions() {
        return this.sendingOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SuppressionOptions suppressionOptions() {
        return this.suppressionOptions;
    }

    public final VdmOptions vdmOptions() {
        return this.vdmOptions;
    }

    public final ArchivingOptions archivingOptions() {
        return this.archivingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vdmOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.archivingOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetRequest)) {
            return false;
        }
        CreateConfigurationSetRequest other = (CreateConfigurationSetRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.trackingOptions(), other.trackingOptions()) && Objects.equals(this.deliveryOptions(), other.deliveryOptions()) && Objects.equals(this.reputationOptions(), other.reputationOptions()) && Objects.equals(this.sendingOptions(), other.sendingOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.suppressionOptions(), other.suppressionOptions()) && Objects.equals(this.vdmOptions(), other.vdmOptions()) && Objects.equals(this.archivingOptions(), other.archivingOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfigurationSetRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("TrackingOptions", (Object)this.trackingOptions()).add("DeliveryOptions", (Object)this.deliveryOptions()).add("ReputationOptions", (Object)this.reputationOptions()).add("SendingOptions", (Object)this.sendingOptions()).add("Tags", this.hasTags() ? this.tags() : null).add("SuppressionOptions", (Object)this.suppressionOptions()).add("VdmOptions", (Object)this.vdmOptions()).add("ArchivingOptions", (Object)this.archivingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "TrackingOptions": {
                return Optional.ofNullable(clazz.cast(this.trackingOptions()));
            }
            case "DeliveryOptions": {
                return Optional.ofNullable(clazz.cast(this.deliveryOptions()));
            }
            case "ReputationOptions": {
                return Optional.ofNullable(clazz.cast(this.reputationOptions()));
            }
            case "SendingOptions": {
                return Optional.ofNullable(clazz.cast(this.sendingOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SuppressionOptions": {
                return Optional.ofNullable(clazz.cast(this.suppressionOptions()));
            }
            case "VdmOptions": {
                return Optional.ofNullable(clazz.cast(this.vdmOptions()));
            }
            case "ArchivingOptions": {
                return Optional.ofNullable(clazz.cast(this.archivingOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("TrackingOptions", TRACKING_OPTIONS_FIELD);
        map.put("DeliveryOptions", DELIVERY_OPTIONS_FIELD);
        map.put("ReputationOptions", REPUTATION_OPTIONS_FIELD);
        map.put("SendingOptions", SENDING_OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SuppressionOptions", SUPPRESSION_OPTIONS_FIELD);
        map.put("VdmOptions", VDM_OPTIONS_FIELD);
        map.put("ArchivingOptions", ARCHIVING_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationSetRequest, T> g) {
        return obj -> g.apply((CreateConfigurationSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private TrackingOptions trackingOptions;
        private DeliveryOptions deliveryOptions;
        private ReputationOptions reputationOptions;
        private SendingOptions sendingOptions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private SuppressionOptions suppressionOptions;
        private VdmOptions vdmOptions;
        private ArchivingOptions archivingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.trackingOptions(model.trackingOptions);
            this.deliveryOptions(model.deliveryOptions);
            this.reputationOptions(model.reputationOptions);
            this.sendingOptions(model.sendingOptions);
            this.tags(model.tags);
            this.suppressionOptions(model.suppressionOptions);
            this.vdmOptions(model.vdmOptions);
            this.archivingOptions(model.archivingOptions);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return this.trackingOptions != null ? this.trackingOptions.toBuilder() : null;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final DeliveryOptions.Builder getDeliveryOptions() {
            return this.deliveryOptions != null ? this.deliveryOptions.toBuilder() : null;
        }

        public final void setDeliveryOptions(DeliveryOptions.BuilderImpl deliveryOptions) {
            this.deliveryOptions = deliveryOptions != null ? deliveryOptions.build() : null;
        }

        @Override
        public final Builder deliveryOptions(DeliveryOptions deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        public final ReputationOptions.Builder getReputationOptions() {
            return this.reputationOptions != null ? this.reputationOptions.toBuilder() : null;
        }

        public final void setReputationOptions(ReputationOptions.BuilderImpl reputationOptions) {
            this.reputationOptions = reputationOptions != null ? reputationOptions.build() : null;
        }

        @Override
        public final Builder reputationOptions(ReputationOptions reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        public final SendingOptions.Builder getSendingOptions() {
            return this.sendingOptions != null ? this.sendingOptions.toBuilder() : null;
        }

        public final void setSendingOptions(SendingOptions.BuilderImpl sendingOptions) {
            this.sendingOptions = sendingOptions != null ? sendingOptions.build() : null;
        }

        @Override
        public final Builder sendingOptions(SendingOptions sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SuppressionOptions.Builder getSuppressionOptions() {
            return this.suppressionOptions != null ? this.suppressionOptions.toBuilder() : null;
        }

        public final void setSuppressionOptions(SuppressionOptions.BuilderImpl suppressionOptions) {
            this.suppressionOptions = suppressionOptions != null ? suppressionOptions.build() : null;
        }

        @Override
        public final Builder suppressionOptions(SuppressionOptions suppressionOptions) {
            this.suppressionOptions = suppressionOptions;
            return this;
        }

        public final VdmOptions.Builder getVdmOptions() {
            return this.vdmOptions != null ? this.vdmOptions.toBuilder() : null;
        }

        public final void setVdmOptions(VdmOptions.BuilderImpl vdmOptions) {
            this.vdmOptions = vdmOptions != null ? vdmOptions.build() : null;
        }

        @Override
        public final Builder vdmOptions(VdmOptions vdmOptions) {
            this.vdmOptions = vdmOptions;
            return this;
        }

        public final ArchivingOptions.Builder getArchivingOptions() {
            return this.archivingOptions != null ? this.archivingOptions.toBuilder() : null;
        }

        public final void setArchivingOptions(ArchivingOptions.BuilderImpl archivingOptions) {
            this.archivingOptions = archivingOptions != null ? archivingOptions.build() : null;
        }

        @Override
        public final Builder archivingOptions(ArchivingOptions archivingOptions) {
            this.archivingOptions = archivingOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetRequest build() {
            return new CreateConfigurationSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationSetRequest> {
        public Builder configurationSetName(String var1);

        public Builder trackingOptions(TrackingOptions var1);

        default public Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return this.trackingOptions((TrackingOptions)((TrackingOptions.Builder)TrackingOptions.builder().applyMutation(trackingOptions)).build());
        }

        public Builder deliveryOptions(DeliveryOptions var1);

        default public Builder deliveryOptions(Consumer<DeliveryOptions.Builder> deliveryOptions) {
            return this.deliveryOptions((DeliveryOptions)((DeliveryOptions.Builder)DeliveryOptions.builder().applyMutation(deliveryOptions)).build());
        }

        public Builder reputationOptions(ReputationOptions var1);

        default public Builder reputationOptions(Consumer<ReputationOptions.Builder> reputationOptions) {
            return this.reputationOptions((ReputationOptions)((ReputationOptions.Builder)ReputationOptions.builder().applyMutation(reputationOptions)).build());
        }

        public Builder sendingOptions(SendingOptions var1);

        default public Builder sendingOptions(Consumer<SendingOptions.Builder> sendingOptions) {
            return this.sendingOptions((SendingOptions)((SendingOptions.Builder)SendingOptions.builder().applyMutation(sendingOptions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder suppressionOptions(SuppressionOptions var1);

        default public Builder suppressionOptions(Consumer<SuppressionOptions.Builder> suppressionOptions) {
            return this.suppressionOptions((SuppressionOptions)((SuppressionOptions.Builder)SuppressionOptions.builder().applyMutation(suppressionOptions)).build());
        }

        public Builder vdmOptions(VdmOptions var1);

        default public Builder vdmOptions(Consumer<VdmOptions.Builder> vdmOptions) {
            return this.vdmOptions((VdmOptions)((VdmOptions.Builder)VdmOptions.builder().applyMutation(vdmOptions)).build());
        }

        public Builder archivingOptions(ArchivingOptions var1);

        default public Builder archivingOptions(Consumer<ArchivingOptions.Builder> archivingOptions) {
            return this.archivingOptions((ArchivingOptions)((ArchivingOptions.Builder)ArchivingOptions.builder().applyMutation(archivingOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

