/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SOARecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SOARecord> {
    private static final SdkField<String> PRIMARY_NAME_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryNameServer").getter(SOARecord.getter(SOARecord::primaryNameServer)).setter(SOARecord.setter(Builder::primaryNameServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryNameServer").build()}).build();
    private static final SdkField<String> ADMIN_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminEmail").getter(SOARecord.getter(SOARecord::adminEmail)).setter(SOARecord.setter(Builder::adminEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminEmail").build()}).build();
    private static final SdkField<Long> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SerialNumber").getter(SOARecord.getter(SOARecord::serialNumber)).setter(SOARecord.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_NAME_SERVER_FIELD, ADMIN_EMAIL_FIELD, SERIAL_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SOARecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String primaryNameServer;
    private final String adminEmail;
    private final Long serialNumber;

    private SOARecord(BuilderImpl builder) {
        this.primaryNameServer = builder.primaryNameServer;
        this.adminEmail = builder.adminEmail;
        this.serialNumber = builder.serialNumber;
    }

    public final String primaryNameServer() {
        return this.primaryNameServer;
    }

    public final String adminEmail() {
        return this.adminEmail;
    }

    public final Long serialNumber() {
        return this.serialNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryNameServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SOARecord)) {
            return false;
        }
        SOARecord other = (SOARecord)obj;
        return Objects.equals(this.primaryNameServer(), other.primaryNameServer()) && Objects.equals(this.adminEmail(), other.adminEmail()) && Objects.equals(this.serialNumber(), other.serialNumber());
    }

    public final String toString() {
        return ToString.builder((String)"SOARecord").add("PrimaryNameServer", (Object)this.primaryNameServer()).add("AdminEmail", (Object)this.adminEmail()).add("SerialNumber", (Object)this.serialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryNameServer": {
                return Optional.ofNullable(clazz.cast(this.primaryNameServer()));
            }
            case "AdminEmail": {
                return Optional.ofNullable(clazz.cast(this.adminEmail()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrimaryNameServer", PRIMARY_NAME_SERVER_FIELD);
        map.put("AdminEmail", ADMIN_EMAIL_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SOARecord, T> g) {
        return obj -> g.apply((SOARecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryNameServer;
        private String adminEmail;
        private Long serialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SOARecord model) {
            this.primaryNameServer(model.primaryNameServer);
            this.adminEmail(model.adminEmail);
            this.serialNumber(model.serialNumber);
        }

        public final String getPrimaryNameServer() {
            return this.primaryNameServer;
        }

        public final void setPrimaryNameServer(String primaryNameServer) {
            this.primaryNameServer = primaryNameServer;
        }

        @Override
        public final Builder primaryNameServer(String primaryNameServer) {
            this.primaryNameServer = primaryNameServer;
            return this;
        }

        public final String getAdminEmail() {
            return this.adminEmail;
        }

        public final void setAdminEmail(String adminEmail) {
            this.adminEmail = adminEmail;
        }

        @Override
        public final Builder adminEmail(String adminEmail) {
            this.adminEmail = adminEmail;
            return this;
        }

        public final Long getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(Long serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(Long serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public SOARecord build() {
            return new SOARecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SOARecord> {
        public Builder primaryNameServer(String var1);

        public Builder adminEmail(String var1);

        public Builder serialNumber(Long var1);
    }
}

