/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.MultiRegionEndpoint;
import software.amazon.awssdk.services.sesv2.model.MultiRegionEndpointsCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultiRegionEndpointsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListMultiRegionEndpointsResponse> {
    private static final SdkField<List<MultiRegionEndpoint>> MULTI_REGION_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiRegionEndpoints").getter(ListMultiRegionEndpointsResponse.getter(ListMultiRegionEndpointsResponse::multiRegionEndpoints)).setter(ListMultiRegionEndpointsResponse.setter(Builder::multiRegionEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMultiRegionEndpointsResponse.getter(ListMultiRegionEndpointsResponse::nextToken)).setter(ListMultiRegionEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_REGION_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMultiRegionEndpointsResponse.memberNameToFieldInitializer();
    private final List<MultiRegionEndpoint> multiRegionEndpoints;
    private final String nextToken;

    private ListMultiRegionEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.multiRegionEndpoints = builder.multiRegionEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMultiRegionEndpoints() {
        return this.multiRegionEndpoints != null && !(this.multiRegionEndpoints instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionEndpoint> multiRegionEndpoints() {
        return this.multiRegionEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiRegionEndpoints() ? this.multiRegionEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiRegionEndpointsResponse)) {
            return false;
        }
        ListMultiRegionEndpointsResponse other = (ListMultiRegionEndpointsResponse)((Object)obj);
        return this.hasMultiRegionEndpoints() == other.hasMultiRegionEndpoints() && Objects.equals(this.multiRegionEndpoints(), other.multiRegionEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMultiRegionEndpointsResponse").add("MultiRegionEndpoints", this.hasMultiRegionEndpoints() ? this.multiRegionEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiRegionEndpoints": {
                return Optional.ofNullable(clazz.cast(this.multiRegionEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MultiRegionEndpoints", MULTI_REGION_ENDPOINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMultiRegionEndpointsResponse, T> g) {
        return obj -> g.apply((ListMultiRegionEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<MultiRegionEndpoint> multiRegionEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiRegionEndpointsResponse model) {
            super(model);
            this.multiRegionEndpoints(model.multiRegionEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<MultiRegionEndpoint.Builder> getMultiRegionEndpoints() {
            List<MultiRegionEndpoint.Builder> result = MultiRegionEndpointsCopier.copyToBuilder(this.multiRegionEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiRegionEndpoints(Collection<MultiRegionEndpoint.BuilderImpl> multiRegionEndpoints) {
            this.multiRegionEndpoints = MultiRegionEndpointsCopier.copyFromBuilder(multiRegionEndpoints);
        }

        @Override
        public final Builder multiRegionEndpoints(Collection<MultiRegionEndpoint> multiRegionEndpoints) {
            this.multiRegionEndpoints = MultiRegionEndpointsCopier.copy(multiRegionEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionEndpoints(MultiRegionEndpoint ... multiRegionEndpoints) {
            this.multiRegionEndpoints(Arrays.asList(multiRegionEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionEndpoints(Consumer<MultiRegionEndpoint.Builder> ... multiRegionEndpoints) {
            this.multiRegionEndpoints(Stream.of(multiRegionEndpoints).map(c -> (MultiRegionEndpoint)((MultiRegionEndpoint.Builder)MultiRegionEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMultiRegionEndpointsResponse build() {
            return new ListMultiRegionEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultiRegionEndpointsResponse> {
        public Builder multiRegionEndpoints(Collection<MultiRegionEndpoint> var1);

        public Builder multiRegionEndpoints(MultiRegionEndpoint ... var1);

        public Builder multiRegionEndpoints(Consumer<MultiRegionEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

