/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.sesv2.auth.scheme.SesV2AuthSchemeParams;
import software.amazon.awssdk.services.sesv2.auth.scheme.SesV2AuthSchemeProvider;
import software.amazon.awssdk.services.sesv2.auth.scheme.internal.ModeledSesV2AuthSchemeProvider;
import software.amazon.awssdk.services.sesv2.auth.scheme.internal.SesV2EndpointResolverAware;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointParams;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultSesV2AuthSchemeProvider
implements SesV2AuthSchemeProvider {
    private static final DefaultSesV2AuthSchemeProvider DEFAULT = new DefaultSesV2AuthSchemeProvider();
    private static final SesV2AuthSchemeProvider MODELED_RESOLVER = ModeledSesV2AuthSchemeProvider.create();
    private static final SesV2EndpointProvider DELEGATE = SesV2EndpointProvider.defaultProvider();

    private DefaultSesV2AuthSchemeProvider() {
    }

    public static SesV2AuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(SesV2AuthSchemeParams params) {
        SesV2EndpointParams endpointParameters = SesV2EndpointParams.builder().region(params.region()).useDualStack(params.useDualStack()).useFips(params.useFips()).endpoint(params.endpoint()).endpointId(params.endpointId()).build();
        Endpoint endpoint = (Endpoint)CompletableFutureUtils.joinLikeSync(this.endpointProvider(params).resolveEndpoint(endpointParameters));
        List authSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
        if (authSchemes == null) {
            return MODELED_RESOLVER.resolveAuthScheme(params);
        }
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        block8: for (EndpointAuthScheme authScheme : authSchemes) {
            String name;
            switch (name = authScheme.name()) {
                case "sigv4": {
                    SigV4AuthScheme sigv4AuthScheme = (SigV4AuthScheme)Validate.isInstanceOf(SigV4AuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    AuthSchemeOption sigv4AuthSchemeOption = (AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)sigv4AuthScheme.signingName()).putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)sigv4AuthScheme.signingRegion()).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!sigv4AuthScheme.disableDoubleEncoding() ? 1 : 0)).build();
                    options.add(sigv4AuthSchemeOption);
                    continue block8;
                }
                case "sigv4a": {
                    SigV4aAuthScheme sigv4aAuthScheme = (SigV4aAuthScheme)Validate.isInstanceOf(SigV4aAuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    RegionSet regionSet = RegionSet.create((Collection)sigv4aAuthScheme.signingRegionSet());
                    AuthSchemeOption sigv4aAuthSchemeOption = (AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4a").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)sigv4aAuthScheme.signingName()).putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!sigv4aAuthScheme.disableDoubleEncoding() ? 1 : 0)).build();
                    options.add(sigv4aAuthSchemeOption);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown auth scheme: " + name);
        }
        return Collections.unmodifiableList(options);
    }

    private SesV2EndpointProvider endpointProvider(SesV2AuthSchemeParams params) {
        SesV2EndpointResolverAware endpointAwareParams;
        SesV2EndpointProvider endpointProvider;
        if (params instanceof SesV2EndpointResolverAware && (endpointProvider = (endpointAwareParams = (SesV2EndpointResolverAware)((Object)params)).endpointProvider()) != null) {
            return endpointProvider;
        }
        return DELEGATE;
    }
}

