/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ScalingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DedicatedIpPool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DedicatedIpPool> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(DedicatedIpPool.getter(DedicatedIpPool::poolName)).setter(DedicatedIpPool.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> SCALING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingMode").getter(DedicatedIpPool.getter(DedicatedIpPool::scalingModeAsString)).setter(DedicatedIpPool.setter(Builder::scalingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD, SCALING_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String poolName;
    private final String scalingMode;

    private DedicatedIpPool(BuilderImpl builder) {
        this.poolName = builder.poolName;
        this.scalingMode = builder.scalingMode;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final ScalingMode scalingMode() {
        return ScalingMode.fromValue(this.scalingMode);
    }

    public final String scalingModeAsString() {
        return this.scalingMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DedicatedIpPool)) {
            return false;
        }
        DedicatedIpPool other = (DedicatedIpPool)obj;
        return Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.scalingModeAsString(), other.scalingModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DedicatedIpPool").add("PoolName", (Object)this.poolName()).add("ScalingMode", (Object)this.scalingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "ScalingMode": {
                return Optional.ofNullable(clazz.cast(this.scalingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DedicatedIpPool, T> g) {
        return obj -> g.apply((DedicatedIpPool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolName;
        private String scalingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DedicatedIpPool model) {
            this.poolName(model.poolName);
            this.scalingMode(model.scalingMode);
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getScalingMode() {
            return this.scalingMode;
        }

        public final void setScalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
        }

        @Override
        public final Builder scalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
            return this;
        }

        @Override
        public final Builder scalingMode(ScalingMode scalingMode) {
            this.scalingMode(scalingMode == null ? null : scalingMode.toString());
            return this;
        }

        public DedicatedIpPool build() {
            return new DedicatedIpPool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DedicatedIpPool> {
        public Builder poolName(String var1);

        public Builder scalingMode(String var1);

        public Builder scalingMode(ScalingMode var1);
    }
}

